<?php

namespace Modules\Amazon\Console;

use Modules\Amazon\Abstractions\AbstractAmazonCommand;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Jobs\CreateAmazonReportJob;
use Modules\Amazon\Repositories\AmazonReportRepository;
use Throwable;

class CreateAmazonReportsCommand extends AbstractAmazonCommand
{
    /**
     * The console command name.
     *
     * @var string
     */
    protected $signature = 'amazon:reports:create {integrationInstanceId?}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Create queued Amazon Reports.';

    /**
     * Create a new command instance.
     */
    public function __construct(
        private readonly AmazonReportRepository $reportRepository
    ) {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @throws Throwable
     */
    public function handle(): void
    {
        $this->integrationInstances()->each(function (AmazonIntegrationInstance $amazonIntegrationInstance) {
            foreach ($this->reportRepository->getRequests($amazonIntegrationInstance) as $amazonReportRequest) {
                dispatch(new CreateAmazonReportJob($amazonReportRequest->id));
            }
        });
    }
}
