<?php

namespace Modules\Amazon\Console;

use DB;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Crypt;

class ChangeEncryptionToNewCode extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'amazon:patch:change-encryption-to-new-code';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Update the fulfilment status for over fulfilled orders.';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     */
    public function handle(): int
    {
        DB::table('amazon_orders')->select('*')->limit(10)->get()->each(function ($amazonOrder) {
            if ($amazonOrder->ShippingAddress != '[]') {
                $jsonObject = json_decode($amazonOrder->json_object, true);
                $shippingAddress = @$jsonObject['ShippingAddress'];
                $buyerInfo = @$jsonObject['BuyerInfo'];

                if ($shippingAddress) {
                    foreach ($shippingAddress as $key => $value) {
                        try {
                            $oldValue = Crypt::decryptString($value);
                            $newValue = encryptValue($oldValue);
                            $shippingAddress[$key] = $newValue;
                        } catch (\Illuminate\Contracts\Encryption\DecryptException $ex) {
                        }
                    }
                }

                if ($buyerInfo) {
                    foreach ($buyerInfo as $key => $value) {
                        try {
                            $oldValue = Crypt::decryptString($value);
                            $newValue = encryptValue($oldValue);
                            $buyerInfo[$key] = $newValue;
                        } catch (\Illuminate\Contracts\Encryption\DecryptException $ex) {
                        }
                    }
                }

                $jsonObject = array_merge($jsonObject, [
                    'ShippingAddress' => $shippingAddress,
                    'BuyerInfo' => $buyerInfo,
                ]);

                DB::table('amazon_orders')->where('id', $amazonOrder->id)->update([
                    'json_object' => $jsonObject,
                ]);
            }
        });

        return 0;
    }
}
