<?php

namespace Modules\Amazon\ApiDataTransferObjects;

use App\Abstractions\Integrations\ApiDataTransformerInterface;
use Carbon\Carbon;
use Modules\Amazon\ApiDataTransferObjects\Concerns\AmazonDatesTrait;
use Modules\Amazon\Enums\Entities\AmazonReportTypeEnum;

class AmazonGetReportsAdt implements ApiDataTransformerInterface
{
    use AmazonDatesTrait;

    const DATES_TO_SANITIZE = [
        'start',
        'end',
    ];

    public function __construct(
        public AmazonReportTypeEnum $reportType,
        public ?array $processingStatuses = null,
        public ?string $nextToken = null,
        public Carbon|string|null $start = null,
        public Carbon|string|null $end = null,
        public ?int $days = null,
        public ?array $marketplaceIds = null,
    ) {
        $this->sanitizeDates();
        if (! is_null($days)) {
            $this->setStartAndEndDateFromDays($days);
        }
    }

    public function transform(): array
    {
        $params = [
            'reportTypes' => $this->reportType?->value,
            'processingStatuses' => toCsv($this->processingStatuses),
            'nextToken' => $this->nextToken,
            'start' => $this->getZuluDate('start'),
            'end' => $this->getZuluDate('end'),
            'marketplaceIds' => $this->marketplaceIds,
        ];

        return array_filter($params, fn ($param) => ! is_null($param));
    }
}
