<?php

namespace Modules\Amazon\ApiDataTransferObjects;

use App\Abstractions\Integrations\ApiDataTransformerInterface;
use Carbon\Carbon;
use Modules\Amazon\ApiDataTransferObjects\Concerns\AmazonDatesTrait;

class AmazonGetOrdersAdt implements ApiDataTransformerInterface
{
    use AmazonDatesTrait;

    const DATES_TO_SANITIZE = [
        'created_after',
        'created_before',
        'last_updated_after',
        'last_updated_before',
    ];

    public function __construct(
        public Carbon|string|null $created_after = null,
        public Carbon|string|null $created_before = null,
        public Carbon|string|null $last_updated_after = null,
        public Carbon|string|null $last_updated_before = null,
        public ?int $days = null,
        public ?string $nextToken = null,
    ) {
        $this->sanitizeDates();
        if (! is_null($days)) {
            $this->setStartAndEndDateFromDays($days);
        }
    }

    public function transform(): array
    {
        $params = [
            'CreatedAfter' => $this->getZuluDate('created_after'),
            'CreatedBefore' => $this->getZuluDate('created_before'),
            'LastUpdatedAfter' => $this->getZuluDate('last_updated_after'),
            'LastUpdatedBefore' => $this->getZuluDate('last_updated_before'),
            'NextToken' => $this->nextToken,
        ];

        return array_filter($params, fn ($param) => ! is_null($param));
    }
}
