<?php

namespace Modules\Amazon\ApiDataTransferObjects;

use App\Abstractions\Integrations\ApiDataTransformerInterface;

class AmazonGetInboundPlanAdt implements ApiDataTransformerInterface
{
    public function __construct(
        public string $planId,
    ) {
    }

    public function transform(): array
    {
        $params = [
            'planId' => $this->planId,
        ];

        return array_filter($params, fn ($param) => ! is_null($param));
    }
}
