<?php

namespace Modules\Amazon\Actions\LedgerSummaryActions;

use App\Exceptions\InsufficientStockException;
use Exception;
use Illuminate\Support\Collection;
use Modules\Amazon\Data\AmazonLedgerSummaryAdjustmentData;
use Modules\Amazon\Entities\AmazonFbaReportInventoryLedgerSummary;
use Modules\Amazon\Enums\Entities\AmazonLedgerSummaryAdjustmentTypeEnum;
use Modules\Amazon\Enums\Entities\AmazonReportTypeEnum;
use Modules\Amazon\Repositories\AmazonLedgerSummaryRepository;
use Modules\Amazon\Repositories\AmazonReportRepository;
use Throwable;

class AmazonLedgerSummaryMissingWithoutSummaryReportHandler
{
    public function __construct(
        private readonly AmazonLedgerSummaryRepository $summaries,
        private readonly AmazonReportRepository $reports
    ) {}

    /**
     * @throws InsufficientStockException
     * @throws Throwable
     */
    public function handle(AmazonFbaReportInventoryLedgerSummary $ledgerSummary, Collection $amazonLedgerSummaryAdjustmentDataCollection): void
    {
        if ($ledgerSummary->ledgerSummaryAdjustments->where('type', AmazonLedgerSummaryAdjustmentTypeEnum::MissingWithoutSummaryReportAdjustment)->isNotEmpty()) {
            throw new Exception('Unexpected attempt to adjust for missing without summary report on the same ledger summary twice');
        }

        if (
            !$this->summaries->getNextSummary($ledgerSummary) &&
            $this->reports->wasReportTypeProcessedForDate(AmazonReportTypeEnum::FBA_REPORT_INVENTORY_LEDGER_SUMMARY, $ledgerSummary->event_datetime->addDay()) &&
            $ledgerSummary->total_inventory_quantity > 0
        )
        {
            $amazonLedgerSummaryAdjustmentDataCollection->push(AmazonLedgerSummaryAdjustmentData::from([
                'amazon_fba_report_inventory_ledger_summary_id' => $ledgerSummary->id,
                'type' => AmazonLedgerSummaryAdjustmentTypeEnum::MissingWithoutSummaryReportAdjustment,
                'inventory_adjustment_id' => app(AmazonCreateInventoryAdjustmentFromLedgerSummary::class)->handle(
                    $ledgerSummary,
                    -$ledgerSummary->total_inventory_quantity,
                    "FNSKU $ledgerSummary->fnsku " . friendlyName(AmazonLedgerSummaryAdjustmentTypeEnum::MissingWithoutSummaryReportAdjustment->value),
                    $ledgerSummary->event_datetime->addDay()
                )->id,
            ]));
        }
    }
}