<?php

namespace Modules\Amazon\Actions\LedgerSummaryActions;

use Modules\Amazon\Entities\AmazonFbaReportInventoryLedgerSummary;
use Modules\Amazon\Enums\Entities\FbaInventoryLedgerReportEventTypeEnum;
use Modules\Amazon\Repositories\AmazonLedgerSummaryRepository;

class AmazonLedgerSummaryErrorHandler
{
    public function __construct(private readonly AmazonLedgerSummaryRepository $summaries) {}

    public function handle(AmazonFbaReportInventoryLedgerSummary $ledgerSummary): AmazonFbaReportInventoryLedgerSummary
    {
        $groupedLedgers = $ledgerSummary->ledgers->groupBy('event_type');
        foreach ($groupedLedgers as $eventType => $ledgers) {
            $eventType = FbaInventoryLedgerReportEventTypeEnum::from($eventType);
            $total = 0;
            foreach ($ledgers as $ledger) {
                if (is_null($ledger->reconciled_at)) {
                    return $this->summaries->markError($ledgerSummary, "Ledger not reconciled");
                }
                $total += $ledger->quantity;
            }

            $field = $this->summaries->getFieldByEventType($eventType);
            if ($ledgerSummary->{$field} != $total) {
                return $this->summaries->markError($ledgerSummary, "Mismatched {$eventType->value} total");
            }
        }
        return $ledgerSummary;
    }
}