<?php

namespace Modules\Amazon\Actions\LedgerActions;

use App\Models\InventoryAdjustment;
use App\Models\PurchaseOrderShipmentReceiptLine;
use App\Models\SalesCreditReturnLine;
use App\Models\SalesOrderFulfillmentLine;
use App\Models\WarehouseTransferShipmentLine;
use App\Models\WarehouseTransferShipmentReceiptLine;
use Closure;
use Exception;
use Modules\Amazon\Actions\LedgerActions\SkuModels\AmazonProcessInventoryAdjustment;
use Modules\Amazon\Actions\LedgerActions\SkuModels\AmazonProcessSalesCreditReturnLine;
use Modules\Amazon\Actions\LedgerActions\SkuModels\AmazonProcessSalesOrderFulfillmentLine;
use Modules\Amazon\Actions\LedgerActions\SkuModels\AmazonProcessWarehouseTransferOrPurchaseOrderShipmentReceipt;
use Modules\Amazon\Actions\LedgerActions\SkuModels\AmazonProcessWarehouseTransferShipmentLine;
use Modules\Amazon\Entities\AmazonFbaReportInventoryLedger;
use Modules\Amazon\Repositories\AmazonLedgerRepository;
use Throwable;

class AmazonProcessSkuModel
{
    public function __construct(
        private readonly AmazonLedgerRepository $ledgers,
    ) {}

    /**
     * @throws Exception
     * @throws Throwable
     */
    public function handle(AmazonFbaReportInventoryLedger $ledger, Closure $next)
    {
        $skuModel = $this->ledgers->getSkuModelFromLedgerEventType($ledger->event_type);

        switch ($skuModel) {
            case InventoryAdjustment::class:
                app(AmazonProcessInventoryAdjustment::class)->handle($ledger);
                break;
            case SalesCreditReturnLine::class:
                app(AmazonProcessSalesCreditReturnLine::class)->handle($ledger);
                break;
            case [WarehouseTransferShipmentReceiptLine::class, PurchaseOrderShipmentReceiptLine::class]:
                app(AmazonProcessWarehouseTransferOrPurchaseOrderShipmentReceipt::class)->handle($ledger);
                break;
            case SalesOrderFulfillmentLine::class:
                app(AmazonProcessSalesOrderFulfillmentLine::class)->handle($ledger);
                break;
            case WarehouseTransferShipmentLine::class:
                app(AmazonProcessWarehouseTransferShipmentLine::class)->handle($ledger);
                break;
            default:
                break;
        }

        return $next($ledger->refresh());
    }
}