<?php

namespace Modules\Amazon\Actions\LedgerActions;

use Closure;
use Modules\Amazon\Entities\AmazonFbaReportInventoryLedger;
use Modules\Amazon\Exceptions\LedgerReconciledOutOfOrderException;
use Modules\Amazon\Repositories\AmazonFnskuRepository;

class AmazonCheckForUnreconciledLedgers
{
    /**
     * @throws LedgerReconciledOutOfOrderException
     */
    public function handle(AmazonFbaReportInventoryLedger $ledger, Closure $next)
    {
        $unreconciledLedgersCount = app(AmazonFnskuRepository::class)->countUnreconciledLedgersBeforeLedger($ledger);
        if ($unreconciledLedgersCount > 0) {
            throw new LedgerReconciledOutOfOrderException("Ledger $ledger->id reconciled out of order. There are $unreconciledLedgersCount unreconciled ledgers before this one.");
        }

        return $next($ledger);
    }
}