<?php

namespace Modules\Amazon\Actions;

use App\Repositories\IntegrationShippingMethodRepository;
use App\Repositories\ShippingCarrierRepository;
use App\Repositories\ShippingMethodRepository;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Enums\Entities\FulfillmentShippingSpeedCategoryEnum;

class InitializeFbaShippingMethods
{
    private ShippingCarrierRepository $shippingCarrierRepository;

    private ShippingMethodRepository $shippingMethodRepository;

    private IntegrationShippingMethodRepository $integrationShippingMethodRepository;

    public function __construct(private readonly AmazonIntegrationInstance $amazonIntegrationInstance)
    {
        $this->shippingCarrierRepository = app(ShippingCarrierRepository::class);
        $this->shippingMethodRepository = app(ShippingMethodRepository::class);
        $this->integrationShippingMethodRepository = app(IntegrationShippingMethodRepository::class);
    }

    public function handle(): void
    {
        customlog('amazon', 'Initializing FBA shipping methods');
        // TODO: May need to handle update as well

        $amazonCarrier = $this->shippingCarrierRepository->save('Amazon MCF');

        $methods = [];
        foreach (FulfillmentShippingSpeedCategoryEnum::values() as $shippingSpeed) {
            $methods[] = [
                'shipping_carrier_id' => $amazonCarrier->id,
                'name' => $shippingSpeed,
            ];
        }

        $this->shippingMethodRepository->save($methods);

        $shippingMethods = $this->shippingMethodRepository->getMethodsFromCarrierId($amazonCarrier->id);

        $integrationMethods = [];
        foreach (FulfillmentShippingSpeedCategoryEnum::values() as $shippingSpeed) {
            $integrationMethods[] = [
                'integration_instance_id' => $this->amazonIntegrationInstance->id,
                'code' => $shippingSpeed,
                'shipping_method_id' => $shippingMethods->where('name', $shippingSpeed)->first()->id,
            ];
        }

        $this->integrationShippingMethodRepository->save($integrationMethods);
    }
}
