<?php

namespace Modules\Amazon\Actions;

/**
 * Class AmazonListingImporter.
 */
class AmazonProductImporter extends ProductImporter
{
    /**
     * @var string
     */
    protected $idColumn = 'seller_sku';

    /**
     * @var string[]
     */
    protected $expectedColumns = [
        'seller_sku',
        'mapped_sku',
    ];

    /**
     * @return mixed|void
     */
    protected function importRow(array $row)
    {
        $row['product_sku'] = $row['mapped_sku'];
        $this->mapper->mapProducts([$row], $this->taskStatus);
    }

    public function finalizeImport()
    {
    }
}
