<?php

namespace Modules\Amazon\Abstractions;

use Illuminate\Console\Command;
use Illuminate\Support\Collection;
use Modules\Amazon\Repositories\AmazonIntegrationInstanceRepository;

abstract class AbstractAmazonCommand extends Command
{
    protected AmazonIntegrationInstanceRepository $integrationInstanceRepository;

    public function __construct()
    {
        parent::__construct();
        $this->integrationInstanceRepository = app(AmazonIntegrationInstanceRepository::class);
    }

    protected function integrationInstances(): Collection
    {
        $integrationInstanceId = $this->argument('integrationInstanceId');
        if ($integrationInstanceId !== null) {
            // If integrationInstanceId is provided, return a collection with a single instance
            return collect([$this->integrationInstanceRepository->getById($integrationInstanceId)]);
        }

        // If no integrationInstanceId is provided, return all instances
        return $this->integrationInstanceRepository->all();
    }
}
