<?php

/**
 * @author
 * @copyright 2009
 */

require_once 'class.gocli.php';

$expected_params = [

    'help' => [
        'short' => 'h',
        'long' => 'help',
        'info' => 'Show this help page.',
        'required' => false,
        'switch' => true,
        'multi' => true,
        'help' => true,
    ],

    'test' => [
        'short' => 'a',
        'long' => 'all',
        'info' => 'This option is internally called "test" (dummy)',
        'required' => true,
        'switch' => false,
        'multi' => true,
    ],

    'file' => [
        'short' => 'f',
        'long' => 'file',
        'info' => 'File to process (dummy)',
        'argument' => 'file',
        'required' => true,
        'switch' => false,
        'multi' => false,
    ],

    'input' => [
        'short' => '',
        'long' => '',
        'info' => 'Input file (dummy)',
        'argument' => 'file',
        'required' => true,
        'switch' => false,
        'multi' => false,
    ],

    'output' => [
        'short' => '',
        'long' => '',
        'info' => 'Output file (dummy)',
        'required' => true,
        'switch' => false,
        'multi' => false,
    ],

    'show_received' => [
        'short' => 'R',
        'long' => 'show-received',
        'info' => 'Show received parameters',
        'required' => false,
        'switch' => true,
        'multi' => false,
    ],

    'show_expected' => [
        'short' => 'X',
        'long' => 'show-expected',
        'info' => 'Show expected parameters',
        'required' => false,
        'switch' => true,
        'multi' => false,
    ],

    'show_data' => [
        'short' => 'D',
        'long' => 'show-data',
        'info' => 'Show interpreted parameter data',
        'required' => false,
        'switch' => true,
        'multi' => false,
    ],

];

$cCLI = new goCLI($expected_params);
$param = $cCLI->go();

if ($param['show_expected']) {
    var_dump($expected_params);
}
if ($param['show_data']) {
    var_dump($cCLI->param_data);
}
if ($param['show_received']) {
    var_dump($param);
}
