<?php

declare(strict_types=1);

namespace Tests\Unit\Utility;

use App\Utility\PhoneNumberUtility;
use Tests\TestCase;

class PhoneNumberUtilityTest extends TestCase
{
    public function test_digitsOnly_returns_numbers_when_provided_with_dashed_number(): void
    {
        $testNumber = '207-924-5260';
        $expected = '2079245260';

        $sutPhoneNumber = PhoneNumberUtility::digitsOnly($testNumber);
        $this->assertEquals(
            $expected,
            $sutPhoneNumber
        );
    }

    public function test_digitsOnly_returns_numbers_when_provided_with_nonsense(): void
    {
        $testNumber = '--10--%##%SG';
        $expected = '10';

        $sutPhoneNumber = PhoneNumberUtility::digitsOnly($testNumber);
        $this->assertEquals(
            $expected,
            $sutPhoneNumber
        );
    }

    public function test_withoutLeadingOne_removes_leading_plus_one(): void
    {
        $testNumber = '+12145426676';
        $expected = '2145426676';

        $sutPhoneNumber = PhoneNumberUtility::withoutLeadingOne($testNumber);
        $this->assertEquals(
            $expected,
            $sutPhoneNumber
        );
    }

    public function test_withoutLeadingOne_removes_leading_one_without_plus(): void
    {
        $testNumber = '12145426676';
        $expected = '2145426676';

        $sutPhoneNumber = PhoneNumberUtility::withoutLeadingOne($testNumber);
        $this->assertEquals(
            $expected,
            $sutPhoneNumber
        );
    }

    public function test_applying_multiple_rules_produces_single_result(): void
    {
        $testNumber = '1-214-542-6676';
        $expected = '2145426676';

        $sutPhoneNumber = PhoneNumberUtility::applyMany(
            $testNumber,
            ['digitsOnly', 'withoutLeadingOne']
        );

        $this->assertEquals(
            $expected,
            $sutPhoneNumber
        );
    }
}
