<?php

namespace Tests\Unit;
use App\Managers\ProductManager;
use App\Models\Attribute;
use App\Models\Product;
use App\Models\ProductAttribute;
use App\Models\ProductBlemished;
use App\Models\ProductPricing;
use Exception;
use Plannr\Laravel\FastRefreshDatabase\Traits\FastRefreshDatabase;
use Tests\TestCase;

class EvaluateTemplateTest extends TestCase
{
    use FastRefreshDatabase;

    protected ProductManager $manager;

    /**
     * @throws Exception
     */
    public function setUp(): void
    {
        parent::setUp();

        $this->manager = app(ProductManager::class);
    }

    /**
     * @throws Exception
     */
    public function test_it_can_resolve_multiple_fields(): void
    {
        $path = '<strong>Note: {{product_blemished.condition}}</strong><br><br>{{product_attributes.ebay_description}}';

        $originalProduct = Product::factory()->create([
            'name' => 'Original Product',
            'sku' => 'ORIGINAL-SKU',
        ]);

        $product = Product::factory()->create([
            'name' => 'Test Product',
            'sku' => 'TEST-SKU',
        ]);

        ProductBlemished::create([
            'product_id' => $product->id,
            'derived_from_product_id' => $originalProduct->id,
            'condition' => 'Slightly used',
            'reference' => 'reference',
        ]);

        $attribute = Attribute::factory()->create([
            'name' => 'ebay_description',
            'type' => 'longtext',
        ]);

        ProductAttribute::factory()->create([
            'product_id' => $product->id,
            'attribute_id' => $attribute->id,
            'value' => 'This is the ebay description',
        ]);

        $result = $this->manager->evaluateTemplate($path, $product);

        $this->assertEquals('<strong>Note: Slightly used</strong><br><br>This is the ebay description', $result);
    }

    /**
     * @throws Exception
     */
    public function test_it_can_resolve_formula(): void
    {
        $path = '0.7*{{product_pricing.retail}}';

        $product = Product::factory()->withProductPricing()->create([
            'name' => 'Test Product',
            'sku' => 'TEST-SKU',
        ]);

        $productPricing = ProductPricing::whereProductId($product->id)->firstOrFail();
        $productPricing->update(['price' => 100]);

        $productPricingTier = $productPricing->productPricingTier;
        $productPricingTier->update(['name' => 'retail']);

        $result = $this->manager->evaluateTemplate($path, $product);

        $this->assertEquals(70, $result);
    }
}
