<?php

namespace Tests\Unit;

use App\Models\Product;
use App\Models\User;
use App\Models\Warehouse;
use Laravel\Sanctum\Sanctum;
use Plannr\Laravel\FastRefreshDatabase\Traits\FastRefreshDatabase;
use Tests\TestCase;
use Throwable;

class DataTableSortingTest extends TestCase
{
    use FastRefreshDatabase;

    /**
     * @throws Throwable
     */
    public function test_it_can_sort_inventory_available_in_products_table()
    {
        Sanctum::actingAs(User::first());

        $product1 = Product::factory()->create([
            'sku' => 'SKU1',
        ]);
        $product2 = Product::factory()->create([
            'sku' => 'SKU2',
        ]);
        $warehouse1 = Warehouse::factory()->create([
            'name' => 'Warehouse1'
        ]);
        $warehouse2 = Warehouse::factory()->create([
            'name' => 'Warehouse2'
        ]);

        $product1->setInitialInventory($warehouse1->id, 10);
        $product2->setInitialInventory($warehouse2->id, 20);

        $payload = [
            'included' => json_encode([
                'sku',
                'inventory_available_warehouses'
            ]),
            'sortObjs' => json_encode([
                [
                    'column' => 'inventory_available_warehouses.Warehouse1',
                    'ascending' => false,
                ]
            ]),
        ];

        $response = $this->getJson(route('products.index') . '?' . http_build_query($payload))->assertOk();

        $this->assertCount(2, $response->json('data'));
        $this->assertEquals('SKU1', $response->json('data.0.sku'));
    }
}