<?php

namespace Tests\Unit;

use Illuminate\Foundation\Testing\WithFaker;
use Tests\TestCase;

class DataEncryptionTest extends TestCase
{
    use WithFaker;

    public function test_it_can_encrypt_string(): void
    {
        $string = $this->faker->word();
        $encrypted = encryptValue($string);
        $this->assertNotEquals($string, $encrypted);
    }

    public function test_it_can_decrypt_string(): void
    {
        $string = $this->faker->word();
        $encrypted = encryptValue($string);
        $decrypted = decryptValueIfEncrypted($encrypted);
        $this->assertEquals($string, $decrypted);
    }

    public function test_it_can_return_unencrypted_value(): void{
        $string = $this->faker->word();
        $decrypted = decryptValueIfEncrypted($string);
        $this->assertEquals($string, $decrypted);
    }

    public function test_it_can_return_null_value(): void{
        $decrypted = decryptValueIfEncrypted(null);
        $this->assertNull($decrypted);
    }

    public function test_it_can_return_empty_string_value(): void{
        $decrypted = decryptValueIfEncrypted('');
        $this->assertEquals('', $decrypted);
    }

    public function test_it_can_return_integer_value(): void{
        $decrypted = decryptValueIfEncrypted(123);
        $this->assertEquals(123, $decrypted);
    }

    public function test_it_can_return_boolean_value(): void{
        $decrypted = decryptValueIfEncrypted(true);
        $this->assertEquals(true, $decrypted);
    }

    public function test_it_can_return_zero_value(): void{
        $decrypted = decryptValueIfEncrypted(0);
        $this->assertEquals(0, $decrypted);
    }

    public function test_it_can_return_string_zero_value(): void{
        $decrypted = decryptValueIfEncrypted('0');
        $this->assertEquals('0', $decrypted);
    }
}
