<?php

namespace Tests\Unit;

use App\Data\ProductWarehouseQuantityData;
use App\Managers\InventoryHealthManager;
use App\Models\Product;
use App\Models\StockTake;
use App\Models\StockTakeItem;
use App\Models\Warehouse;
use Plannr\Laravel\FastRefreshDatabase\Traits\FastRefreshDatabase;
use Tests\TestCase;
use Throwable;

class CreateStockTakeForProductWarehouseQuantitiesTest extends TestCase
{
    use FastRefreshDatabase;

    protected InventoryHealthManager $inventoryHealthManager;

    public function __construct(string $name)
    {
        parent::__construct($name);
        $this->inventoryHealthManager = app(InventoryHealthManager::class);
    }

    /**
     * @throws Throwable
     */
    public function test_it_can_create_stock_take_using_qty_changed()
    {
        $product = Product::factory()->create();
        $warehouse = Warehouse::first();

        $product->setInitialInventory($warehouse->id, 5);

        $productWarehouseQuantities = collect([
            ProductWarehouseQuantityData::from([
                'product_id' => $product->id,
                'warehouse_id' => $warehouse->id,
                'quantity' => -2,
            ])
        ]);

        $this->inventoryHealthManager->createStockTakeForProductWarehouseQuantities($productWarehouseQuantities, 'Test', asAdjustment: true);

        $this->assertDatabaseHas(StockTake::class, [
            'warehouse_id' => $warehouse->id,
            'notes' => 'Test',
        ]);

        $this->assertDatabaseHas(StockTakeItem::class, [
            'product_id' => $product->id,
            'snapshot_inventory' => 5,
            'qty_counted' => 3,
        ]);
    }
}
