<?php

namespace Tests;

use App\Lib\Inspect\Inspect;
use Database\Seeders\TestDatabaseSeeder;
use Illuminate\Contracts\Console\Kernel;
use Illuminate\Foundation\Testing\TestCase as BaseTestCase;
use Illuminate\Foundation\Testing\Traits\CanConfigureMigrationCommands;
use Illuminate\Routing\Middleware\ThrottleRequests;
use Illuminate\Support\Facades\Artisan;

abstract class TestCaseOld extends BaseTestCase
{
    use CanConfigureMigrationCommands;
    use CreatesApplication;

    protected bool $seed = true;

    protected static bool $migrated = false;

    protected string $seeder = TestDatabaseSeeder::class;

    public bool $withTransactions = false;

    public function withoutTransactions()
    {
        $this->withTransactions = false;
    }

    protected function uses(string $trait): bool
    {
        $uses = array_flip(class_uses_recursive(static::class));

        return isset($uses[$trait]);
    }

    protected function setUp(): void
    {
        parent::setUp();

        $this->withoutMiddleware(
            ThrottleRequests::class
        );

        cache()->forget('test-implicit-commit');
        if ($this->uses(RefreshDatabase::class)) {
            $this->truncate();
        }
    }

    protected function tearDown(): void
    {
        if ($this->uses(RefreshDatabase::class) || cache()->get('test-implicit-commit')) {
            cache()->forget('test-implicit-commit');
            $this->truncate();
        }

        // deleteAllTemporaryTables();

        parent::tearDown();
    }

    public function truncate(): void
    {
        $this->artisan('sku:db:truncate', $this->truncateUsing());
    }

    public function print($string)
    {
        fwrite(STDERR, "\n>>\n".$string."\n");
    }

    public function inspect($ob)
    {
        $this->print(Inspect::get($ob));
    }

    protected function truncateUsing(): array
    {
        return [
            '--seed' => $this->shouldSeed(),
            '--seeder' => $this->seeder(),
        ];
    }
}
