<?php

namespace Tests;

/**
 * This is usually used in Automated tests, in some cases you want
 * the ability to invoke private/protected methods.
 */
trait InvokePrivateMethodTrait
{
    /**
     * https://jtreminio.com/2013/03/unit-testing-tutorial-part-3-testing-protected-private-methods-coverage-reports-and-crap/
     *
     * Call protected/private method of a class.
     *
     * @param  object  $object    Instantiated object that we will run method on.
     * @param  string  $methodName Method name to call
     * @param  array  $parameters Array of parameters to pass into method.
     * @return mixed Method return.
     */
    protected function invokePrivateMethod(object $object, string $methodName, array $parameters = [])
    {
        $reflection = new \ReflectionClass(get_class($object));
        $method = $reflection->getMethod($methodName);
        $method->setAccessible(true);

        return $method->invokeArgs($object, $parameters);
    }

    /**
     * https://jtreminio.com/2013/03/unit-testing-tutorial-part-3-testing-protected-private-methods-coverage-reports-and-crap/
     *
     * Call protected/private method of a class.
     *
     * @param  string  $fqcn Class name
     * @param  string  $methodName Method name to call
     * @param  array  $parameters Array of parameters to pass into method.
     * @return mixed Method return.
     */
    protected function invokePrivateStaticMethod(string $fqcn, string $methodName, array $parameters = [])
    {
        $reflection = new \ReflectionClass($fqcn);
        $method = $reflection->getMethod($methodName);
        $method->setAccessible(true);

        return $method->invokeArgs(null, $parameters);
    }
}
