<?php

namespace Tests\Feature;

use Plannr\Laravel\FastRefreshDatabase\Traits\FastRefreshDatabase;
use Tests\TestCase;

/**
 * Must cover all inheritors of AbstractRepository
 * @group manual
 */
class UpsertTestWithDataProviders extends TestCase
{
    use FastRefreshDatabase;

    /**
     * Data provider for upsert functionality tests.
     */
    public static function upsertProvider(): array
    {
        return [
            'Test Addresses' => [
                'repositoryClass' => AddressRepository::class,
                'modelClass' => Address::class,
                'dtoClass' => AddressDto::class,
                'expectedCount' => 3,
                'data' => self::addressData(),
            ],
//            'Test Warehouses' => [
//                'repositoryClass' => WarehouseRepository::class,
//                'modelClass' => Warehouse::class,
//                'dtoClass' => WarehouseDto::class,
//                'expectedCount' => 4,
//                'dataSets' => self::warehouseData(),
//            ],
        ];
    }

    /**
     * @dataProvider upsertProvider
     */
    public function testUpsertFunctionality($repositoryClass, $modelClass, $dtoClass, $expectedCount, $data)
    {
        $collection = $dtoClass::collection($data)->toCollection();
        app($repositoryClass)->save($collection, $modelClass);
        $this->assertDatabaseCount((new $modelClass())->getTable(), $expectedCount - 1);
        app($repositoryClass)->save($collection, $modelClass);
        $this->assertDatabaseCount((new $modelClass())->getTable(), $expectedCount);
    }

    private static function addressData(): array
    {
        return [
            AddressDto::from([
                'name' => 'Test Name',
                'email' => 'test@email.com',
                'city' => 'City',
                'country' => 'Country',
                'label' => 'Test Label2',
            ]),
            AddressDto::from([
                'name' => 'Test Name 2',
                'email' => 'test2@email.com',
                'city' => 'City2',
                'country' => 'Country2',
                'label' => 'Test Label 2',
            ])
        ];
    }

    private static function warehouseData(): array
    {
        return [
            WarehouseDto::from([
                'name' => 'test',
                'type' => 'direct',
                'dropship_enabled' => true,
            ]),
            WarehouseDto::from([
                'name' => 'test2',
                'type' => 'direct',
            ])
        ];
    }
}
