<?php

namespace Tests\Feature;

use App\Exceptions\PurchaseOrder\NotOpenPurchaseOrderException;
use App\Exceptions\PurchaseOrder\ReceivePurchaseOrderLineException;
use App\Models\PurchaseOrder;
use App\Models\PurchaseOrderShipment;
use App\Models\PurchaseOrderShipmentLine;
use App\Models\PurchaseOrderShipmentReceipt;
use App\Models\PurchaseOrderShipmentReceiptLine;
use App\Models\Warehouse;
use App\Services\PurchaseOrder\ShipmentManager;
use Plannr\Laravel\FastRefreshDatabase\Traits\FastRefreshDatabase;
use Tests\TestCase;
use Throwable;

class PurchaseOrderShipmentManagerTest extends TestCase
{
    use FastRefreshDatabase;

    /**
     * @throws Throwable
     * @throws NotOpenPurchaseOrderException
     * @throws ReceivePurchaseOrderLineException
     */
    public function test_it_can_add_lines_to_existing_shipment_receipt()
    {
        // Setup

        $shipmentManager = app(ShipmentManager::class);

        $warehouse = Warehouse::first();
        $purchaseOrder = PurchaseOrder::factory()->withLines(2)->create();

        $firstPurchaseOrderLine = $purchaseOrder->purchaseOrderLines->first();
        $secondPurchaseOrderLine = $purchaseOrder->purchaseOrderLines->last();

        $purchaseOrderReceipt = $shipmentManager->receiveShipment([
            'purchase_order_id' => $purchaseOrder->id,
            'received_at' => now()->toIso8601ZuluString(),
            'warehouse_id' => $warehouse->id,
            'shipment_date' => now()->toIso8601ZuluString(),
            'receipt_lines' => [
                [
                    'purchase_order_line_id' => $firstPurchaseOrderLine->id,
                    'quantity' => $firstPurchaseOrderLine->quantity,
                ],
            ]
        ]);

        $shipmentManager->addLinesToExistingShipmentReceipt($purchaseOrderReceipt, [
            [
                'purchase_order_line_id' => $secondPurchaseOrderLine->id,
                'quantity' => $secondPurchaseOrderLine->quantity,
            ],
        ]);

        $this->assertDatabaseCount(PurchaseOrderShipmentReceiptLine::class, 2);
        $this->assertDatabaseCount(PurchaseOrderShipmentLine::class, 2);
        $this->assertDatabaseCount(PurchaseOrderShipmentReceipt::class, 1);
        $this->assertDatabaseCount(PurchaseOrderShipment::class, 1);
    }
}
