<?php

namespace Tests\Feature;

use App\Models\Customer;
use App\Models\ShippingMethod;
use App\Models\Tag;
use App\Models\User;
use Plannr\Laravel\FastRefreshDatabase\Traits\FastRefreshDatabase;
use Tests\TestCase;

class LookupTest extends TestCase
{
    use FastRefreshDatabase;

    protected static $user;

    protected static $customer;

    protected static $shippingMethod;

    public function test_tags(): void
    {
        // This didn't seem to work in setUpBeforeClass() for some reason
        self::$user = User::factory()->create();
        self::$customer = Customer::factory()->create();
        self::$shippingMethod = ShippingMethod::factory()->create();

        Tag::factory()->create(['name' => 'apple']);
        Tag::factory()->create(['name' => 'apricot']);
        Tag::factory()->create(['name' => 'banana']);
        Tag::factory()->create(['name' => 'bananacake']);
        Tag::factory()->create(['name' => 'orange']);

        $response = $this->actingAs(self::$user)
            ->getJson('api/lookup/tags?input=name&value=a');
        $this->assertEqualsCanonicalizing(
            [
                'apple',
                'apricot',
            ],
            $response->json('data')
        );

        $response = $this->actingAs(self::$user)
            ->getJson('api/lookup/tags?input=name&value=banana');
        $this->assertEqualsCanonicalizing(
            [
                'banana',
                'bananacake',
            ],
            $response->json('data')
        );

        $response = $this->actingAs(self::$user)
            ->getJson('api/lookup/tags?input=name&value=bananacake');
        $this->assertEqualsCanonicalizing(
            [
                'bananacake',
            ],
            $response->json('data')
        );

        $response = $this->actingAs(self::$user)
            ->getJson('api/lookup/tags?input=name&value=missing');
        $this->assertEqualsCanonicalizing(
            [],
            $response->json('data')
        );
    }
}
