<?php

namespace Tests\Feature;

use App\Models\User;
use Tests\TestCase;

class ExportTest extends TestCase
{
    public function test_unauthenticated_users_cannot_export_data(): void
    {
        $this->get('/export/stores')->assertRedirect('login');
    }

    public function test_authenticated_users_can_export_data(): void{

        $this->actingAs(User::factory()->create());
        $this->get('/export/stores')->assertSuccessful()->assertDownload();
    }
}
