<?php

namespace Tests\Feature\Controllers;

use App\Models\User;
use Illuminate\Foundation\Testing\WithFaker;
use Laravel\Sanctum\Sanctum;
use Plannr\Laravel\FastRefreshDatabase\Traits\FastRefreshDatabase;
use Tests\TestCase;

class UserControllerTest extends TestCase
{
    use FastRefreshDatabase,WithFaker;

    protected function setUp(): void
    {
        parent::setUp();
        Sanctum::actingAs(User::first());
    }

    public function test_it_can_create_user_and_send_invitation(): void
    {
        $response = $this->postJson(route('user.invite'), [
            'email' => $this->faker->email,
            'name' => $this->faker->name,
            'is_admin' => $this->faker->boolean,
            'is_power_user' => $this->faker->boolean,
        ])->assertOk();

    }
}
