<?php

namespace Tests\Feature\Controllers;

use App\Data\FinancialLineData;
use App\Models\FinancialLine;
use App\Models\FinancialLineType;
use App\Models\SalesOrder;
use App\Models\User;
use Laravel\Sanctum\Sanctum;
use Plannr\Laravel\FastRefreshDatabase\Traits\FastRefreshDatabase;
use Tests\TestCase;

class FinancialLineTest extends TestCase
{
    use FastRefreshDatabase;

    protected function setUp(): void
    {
        parent::setUp();

        Sanctum::actingAs(User::first());
    }

    public function testSalesOrderFinancialLineController()
    {
        /*
        |--------------------------------------------------------------------------
        | Store
        |--------------------------------------------------------------------------
        */

        $salesOrder = SalesOrder::factory()->create();
        $financialLineType = FinancialLineType::factory()->create();

        $payload = [
            'sales_order_id' => $salesOrder->id,
            'financial_line_type_id' => $financialLineType->id,
            'description' => 'Test Description',
            'amount' => 100,
        ];

        $financialLine = $this->postJson(route('sales-orders.financial-lines.store', $salesOrder),
            FinancialLineData::from($payload)->toArray()
        )->assertCreated();

        $this->assertDatabaseHas((new FinancialLine())->getTable(), $payload);

        /*
        |--------------------------------------------------------------------------
        | Update
        |--------------------------------------------------------------------------
        */

        $payload['description'] = 'Updated Description';

        $this->putJson(route('sales-orders.financial-lines.update', [$salesOrder->id, $financialLine->json('id')]),
            FinancialLineData::from($payload)->toArray()
        )->assertOk();

        $this->assertDatabaseHas((new FinancialLine())->getTable(), $payload);
    }
}
