<?php

namespace Tests\Feature;

use App\Models\User;
use Plannr\Laravel\FastRefreshDatabase\Traits\FastRefreshDatabase;
use Tests\TestCase;
use Tests\TestCaseOld;

class AppSettingsControllerTest extends TestCase
{

    use FastRefreshDatabase;

    public function test_it_can_get_app_settings(): void
    {
        $this->actingAs(User::factory()->create());

        $this->getJson('/api/app-settings')
            ->assertSuccessful()
            ->assertJsonPath('data.websockets.port', config('broadcasting.connections.pusher.options.port'));
    }
}
