<?php

use App\Http\Controllers\Amazon;
use App\Http\Controllers\DBSchemaController;
use App\Http\Controllers\EBay;
use App\Http\Controllers\FrontendController;
use App\Http\Controllers\HorizonController;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use Modules\Xero\Http\Controllers\XeroIntegrationController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

if (is_readable(__DIR__.'/dev_routes.php')) {
    require_once __DIR__.'/dev_routes.php';
}

Route::get('/', [FrontendController::class, 'index'])->name('frontend');

Route::get('/api/amazon/feed_submissions', [Amazon\FeedSubmissionController::class, 'index']);
Route::get('/api/amazon/orders', [Amazon\OrderController::class, 'index']);

Route::get('/dbschema/schema', [DBSchemaController::class, 'schema']);
Route::get('/dbschema/custom', [DBSchemaController::class, 'custom']);
Route::get('/dbschema/meta', [DBSchemaController::class, 'meta']);
Route::post('/dbschema/save', [DBSchemaController::class, 'save']);

Route::get('ebay-auth-accepted', [EBay\EBayIntegrationController::class, 'ebayAuthAccepted']);

Route::prefix('lwa')->group(function () {
    Route::get('step-1', [Amazon\LwaController::class, 'step1']);
    Route::any('step-2', [Amazon\LwaController::class, 'step2']);
    Route::any('step-3', [Amazon\LwaController::class, 'step3']);
});

Route::prefix('xero')->group(function () {
    Route::get('authorize', [XeroIntegrationController::class, 'generateOAuthUrl']);
    Route::get('/auth/callback', [XeroIntegrationController::class, 'callback'])->name('xero.auth.callback');
});

Route::middleware('auth:sanctum')->get('/horizon-restart', [HorizonController::class, 'restartHorizon']);

Route::middleware('auth')->group(function(){
    Route::get('/{any}', [FrontendController::class, 'index'])->where('any', '^(?!api|export|login|password|.*\/callback).*$');
});

Auth::routes();