<?php

use App\Http\Controllers\AttributeController;
use App\Http\Controllers\AttributeGroupController;
use App\Http\Controllers\BackorderLayerController;
use App\Http\Controllers\BackorderQueueController;
use App\Http\Controllers\CustomerController;
use App\Http\Controllers\ExportController;
use App\Http\Controllers\FifoLayerController;
use App\Http\Controllers\InitialInventoryController;
use App\Http\Controllers\IntegrationInstanceController;
use App\Http\Controllers\IntegrationInstanceListingController;
use App\Http\Controllers\InventoryAdjustmentController;
use App\Http\Controllers\InventoryAssemblyController;
use App\Http\Controllers\InventoryManagementController;
use App\Http\Controllers\NominalCodeController;
use App\Http\Controllers\ProductBrandController;
use App\Http\Controllers\ProductCategoryController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\ProductPricingTierController;
use App\Http\Controllers\PurchaseOrderController;
use App\Http\Controllers\PurchaseOrderLineController;
use App\Http\Controllers\SalesCreditController;
use App\Http\Controllers\SalesOrderController;
use App\Http\Controllers\SalesOrderFulfillmentController;
use App\Http\Controllers\SalesOrderLineController;
use App\Http\Controllers\ShippingMethodController;
use App\Http\Controllers\StockTakeController;
use App\Http\Controllers\StoreController;
use App\Http\Controllers\SupplierController;
use App\Http\Controllers\SupplierInventoryController;
use App\Http\Controllers\SupplierPricingController;
use App\Http\Controllers\TagController;
use App\Http\Controllers\WarehouseController;
use App\Http\Controllers\WarehouseTransferController;
use Illuminate\Support\Facades\Route;

// TODO: Needs optimizing: https://chat.openai.com/share/03af042f-9401-42fe-8660-5081f62c4cee

Route::prefix('export/')->name('export.')->group(function () {
    Route::get('/download', [ExportController::class, 'download'])->name('download');

    Route::get('integration-instances/{integration_instance}/listings/export/csv', [IntegrationInstanceListingController::class, 'exportListings']);
    Route::get('integration-instances/{integration_instance}/listings/{format}', [IntegrationInstanceController::class, 'exportListingsInSalesChannel']);
    // Supplier inventory
    Route::get('suppliers/{supplier}/inventory', [SupplierInventoryController::class, 'export']);

    Route::get('products', [ProductController::class, 'export']);
    Route::get('sales-orders', [SalesOrderController::class, 'export']);
    Route::get('purchase-orders', [PurchaseOrderController::class, 'export']);
    Route::get('warehouse-transfers', [WarehouseTransferController::class, 'export']);
    Route::get('sales-credits', [SalesCreditController::class, 'export']);
    Route::get('assemblies', [InventoryAssemblyController::class, 'export']);
    Route::get('stock-takes', [StockTakeController::class, 'export']);
    Route::get('inventory-adjustments', [InventoryAdjustmentController::class, 'export']);
    Route::get('inventory-movements', [InventoryManagementController::class, 'export']);
    Route::get('fifo-layers', [FifoLayerController::class, 'export']);
    Route::get('backorder-layers', [BackorderLayerController::class, 'export']);
    Route::get('warehouses', [WarehouseController::class, 'export']);
    Route::get('suppliers', [SupplierController::class, 'export']);
    Route::get('customers', [CustomerController::class, 'export']);
    Route::get('nominal-codes', [NominalCodeController::class, 'export']);
    Route::get('tags', [TagController::class, 'export']);
    Route::get('shipping-methods', [ShippingMethodController::class, 'export']);
    Route::get('attributes', [AttributeController::class, 'export']);
    Route::get('attribute-groups', [AttributeGroupController::class, 'export']);
    Route::get('product-brands', [ProductBrandController::class, 'export']);
    Route::get('categories', [ProductCategoryController::class, 'export']);
    Route::get('product-pricing-tiers', [ProductPricingTierController::class, 'export']);
    Route::get('supplier-pricing-tiers', [SupplierPricingController::class, 'export']);
    Route::get('stores', [StoreController::class, 'export']);
    Route::get('inventory-assemblies', [InventoryAssemblyController::class, 'export']);
    Route::get('backorder-queue', [BackorderQueueController::class, 'export']);
    Route::get('purchase-orders/{purchase_order}/invoice/csv', [PurchaseOrderController::class, 'downloadInvoiceCSV']);
    Route::get('purchase-orders/{purchase_order}/invoice/pdf', [PurchaseOrderController::class, 'downloadInvoicePDF']);
    Route::get('purchase-orders/{purchase_order}/picklist/pdf', [PurchaseOrderController::class, 'picklist']);
    Route::get('sales-orders/{sales_order}/invoice/pdf', [SalesOrderController::class, 'downloadInvoicePDF']);
    Route::get('sales-orders/packing-slips', [SalesOrderController::class, 'exportPackingSlips']);
    Route::get('sales-order-fulfillments/packing-slips', [SalesOrderFulfillmentController::class, 'exportPackingSlips']);
    Route::get('initial-inventory/{warehouse}/export', [InitialInventoryController::class, 'export'])->name('export-initial-inventory');
    Route::get('stock-takes/{stock_take}/export-lines', [StockTakeController::class, 'exportStockTakeLines']);
    Route::get('purchase-orders/{id}/export-lines', [PurchaseOrderLineController::class, 'exportLines']);
    Route::get('sales-order-fulfillments', [SalesOrderFulfillmentController::class, 'export']);
    Route::get('sales-order-line-financials', [\App\Http\Controllers\SalesOrderLineFinancialController::class, 'export']);
    Route::get('purchase-orders/{id}/export-lines', [PurchaseOrderLineController::class, 'exportLines']);
    Route::get('sales-orders/{id}/export-lines', [SalesOrderLineController::class, 'exportLines']);
    Route::get('warehouse-transfers/{id}/export-lines', [WarehouseTransferController::class, 'exportLines']);
});
