<?php

use App\Http\Controllers\ShipStation;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth.basic.once')->group(function () {
    /**
     * ShipStation Group.
     */
    Route::prefix('shipping-providers')->name('shipping-providers.')->group(function () {
        Route::prefix('shipStation')->group(function () {
            Route::get('export', [ShipStation\OrderController::class, 'shipStationExport']);
            Route::post('ship-notify', [ShipStation\OrderController::class, 'shipStationShipNotify']);
        });
    });
});
