<?php

use App\Http\Controllers\AuthController;
use App\Http\Controllers\EBay;
use App\Http\Controllers\OldSalesChannelController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

/**
 * Login.
 */
Route::prefix('auth')->group(function () {
    Route::middleware('web')->group(function () {
        Route::post('login', [AuthController::class, 'login']);
    });
    Route::get('refresh', [AuthController::class, 'refresh']);
});

/**
 * OAuth accepted APIs. No need authentication.
 */
Route::prefix('sales-channels')->name('sales-channels.')->group(function () {
    // Ebay group
    Route::prefix('ebay')->name('ebay.')->group(function () {
        Route::get('auth-accepted', [EBay\EBayIntegrationController::class, 'ebayAuthAccepted']);
    });

    // Shopify group
    Route::prefix('shopify')->name('shopify.')->group(function () {
        Route::get('auth-accepted', [OldSalesChannelController::class, 'shopifyAuthAccepted']);
    });

    // Google Express group
    Route::prefix('google-express')->name('google-express.')->group(function () {
        Route::get('auth-accepted', [OldSalesChannelController::class, 'googleExpressAuthAccepted']);
    });

    // Magento group
    Route::prefix('magento')->name('magento.')->group(function () {
        Route::post('endpoint', [OldSalesChannelController::class, 'magentoEndpoint']);
        Route::get('auth-accepted', [OldSalesChannelController::class, 'magentoCheckLogin']);
    });
});

Route::middleware('auth:sanctum')->group(function () {
    require __DIR__.'/../exports.php';
});
