<?php

use App\Http\Controllers\AccountingIntegrationController;
use App\Http\Controllers\AccountingPaymentController;
use App\Http\Controllers\AccountingTransactionController;
use App\Http\Controllers\AccountSetupController;
use App\Http\Controllers\ActivityController;
use App\Http\Controllers\AddressController;
use App\Http\Controllers\AdvancedShipmentNoticeController;
use App\Http\Controllers\ApplyPurchaseOrderDiscountLinesController;
use App\Http\Controllers\ApplyPurchaseOrderPricingTierController;
use App\Http\Controllers\AppSettingsController;
use App\Http\Controllers\AttributeController;
use App\Http\Controllers\AttributeGroupController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\BackorderQueueController;
use App\Http\Controllers\BlemishedProductController;
use App\Http\Controllers\CompanyProfileController;
use App\Http\Controllers\ConnectionController;
use App\Http\Controllers\ConstantController;
use App\Http\Controllers\CsvTemplateController;
use App\Http\Controllers\CurrencyController;
use App\Http\Controllers\CustomerAccountingController;
use App\Http\Controllers\CustomerController;
use App\Http\Controllers\CustomFieldController;
use App\Http\Controllers\CustomFieldValueController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\DataFeedController;
use App\Http\Controllers\DropshipController;
use App\Http\Controllers\EBay;
use App\Http\Controllers\ExportController;
use App\Http\Controllers\FifoLayerController;
use App\Http\Controllers\FinancialAlertClassificationController;
use App\Http\Controllers\FinancialAlertController;
use App\Http\Controllers\FinancialController;
use App\Http\Controllers\FinancialLineTypeController;
use App\Http\Controllers\ImportMappingController;
use App\Http\Controllers\IncotermController;
use App\Http\Controllers\InitialInventoryController;
use App\Http\Controllers\IntegrationInstanceController;
use App\Http\Controllers\IntegrationInstanceListingController;
use App\Http\Controllers\InventoryAdjustmentController;
use App\Http\Controllers\InventoryAssemblyController;
use App\Http\Controllers\InventoryForecastController;
use App\Http\Controllers\InventoryManagementController;
use App\Http\Controllers\LookupController;
use App\Http\Controllers\Magento;
use App\Http\Controllers\Magento\OrderController;
use App\Http\Controllers\NominalCodeController;
use App\Http\Controllers\NoteController;
use App\Http\Controllers\PaymentTermController;
use App\Http\Controllers\PaymentTypeController;
use App\Http\Controllers\ProductAttributeController;
use App\Http\Controllers\ProductBrandController;
use App\Http\Controllers\ProductCategoryController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\ProductImageController;
use App\Http\Controllers\ProductListingsController;
use App\Http\Controllers\ProductPricingTierController;
use App\Http\Controllers\ProductVariationController;
use App\Http\Controllers\PurchaseInvoiceController;
use App\Http\Controllers\PurchaseInvoicePaymentController;
use App\Http\Controllers\PurchaseOrderBuilderController;
use App\Http\Controllers\PurchaseOrderController;
use App\Http\Controllers\PurchaseOrderLineController;
use App\Http\Controllers\PurchaseOrderShipmentController;
use App\Http\Controllers\ReportingAccountingController;
use App\Http\Controllers\ReportingController;
use App\Http\Controllers\ReportingDailyFinancialController;
use App\Http\Controllers\ReportTemplateController;
use App\Http\Controllers\ReturnReasonController;
use App\Http\Controllers\SalesChannelController;
use App\Http\Controllers\SalesChannelProductTemplateController;
use App\Http\Controllers\SalesCreditController;
use App\Http\Controllers\SalesCreditPaymentController;
use App\Http\Controllers\SalesOrderController;
use App\Http\Controllers\SalesOrderFinancialLineController;
use App\Http\Controllers\SalesOrderFulfillmentController;
use App\Http\Controllers\SalesOrderLineController;
use App\Http\Controllers\SalesOrderLineFinancialController;
use App\Http\Controllers\SalesOrderPaymentController;
use App\Http\Controllers\SettingController;
use App\Http\Controllers\ShipByScheduleController;
use App\Http\Controllers\ShippingCarrierController;
use App\Http\Controllers\ShippingMethodController;
use App\Http\Controllers\ShippingProviderController;
use App\Http\Controllers\ShipStation;
use App\Http\Controllers\Shopify;
use App\Http\Controllers\Starshipit;
use App\Http\Controllers\StockTakeController;
use App\Http\Controllers\StoreController;
use App\Http\Controllers\StoreEmailTemplateController;
use App\Http\Controllers\SupplierController;
use App\Http\Controllers\SupplierInventoryController;
use App\Http\Controllers\SupplierPricingController;
use App\Http\Controllers\SupplierProductController;
use App\Http\Controllers\SupplierWarehouseController;
use App\Http\Controllers\TableViewController;
use App\Http\Controllers\TagController;
use App\Http\Controllers\TaskStatusController;
use App\Http\Controllers\TaxRateController;
use App\Http\Controllers\TrackedJobLogController;
use App\Http\Controllers\UploadController;
use App\Http\Controllers\UserApiController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\WarehouseController;
use App\Http\Controllers\WarehouseDashboardController;
use App\Http\Controllers\WarehouseLocationController;
use App\Http\Controllers\WarehouseTransferController;
use App\Http\Controllers\WarehouseTransferNoteController;
use App\Http\Controllers\WarehouseTransferShipmentController;
use App\Models\SalesOrderFulfillment;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

if (env('BYPASS_CORS_PROTECTION', false)) {
    if (env('APP_ENV') != 'testing') {
        header('Access-Control-Allow-Origin: *');
        header('Access-Control-Allow-Methods: GET,POST,PUT,PATCH,DELETE,OPTIONS');
        header('Access-Control-Allow-Credentials: true');
        header('Access-Control-Allow-Headers: Authorization, Content-Type');
    }
}

Route::middleware('auth:sanctum')->group(function () {
    /**
     * Authentication Group.
     */
    Route::prefix('auth')->group(function () {
        Route::delete('token', [AuthController::class, 'deleteAccessToken']);
        Route::get('profile', [AuthController::class, 'profile']);
        Route::put('profile', [AuthController::class, 'updateProfile']);
        Route::put('password', [AuthController::class, 'updatePassword']);
        Route::get('alerts', [AuthController::class, 'alerts']);
        Route::get('unread-notifications', [AuthController::class, 'unreadNotifications']);
        Route::put('{activity_log_id}/read-notification', [AuthController::class, 'readNotification']);
    });

    Route::post('/export/create-download-file',
        [ExportController::class, 'createDownloadFile'])->name('export.create-download-file');

    Route::resource('users', UserController::class)->only(['index', 'store', 'update', 'show','destroy']);
    Route::post('users/store-user',[UserController::class,'createUser'])->name('user.invite');

    Route::get('company-profile', [CompanyProfileController::class, 'index']);
    Route::put('company-profile', [CompanyProfileController::class, 'update']);

    /**
     * Products Group.
     */
    Route::prefix('products')->name('products.')->group(function () {
        Route::get('/by-sku', [ProductController::class, 'showBySku'])->name('by-sku');
        //    Route::post('import', [ProductController::class, 'importCSV']);
        Route::put('{id}/archive', [ProductController::class, 'archive']);
        Route::put('{id}/unarchived', [ProductController::class, 'unarchived']);
        Route::get('constants', [ProductController::class, 'constants']);
        Route::get('{productId}/suppliers', [ProductController::class, 'productSuppliers']);
        Route::get('{productId}/components', [ProductController::class, 'productComponents']);
        Route::get('{productId}/bundles', [ProductController::class, 'productBundles']);
        Route::get('{productId}/potential-bundles', [ProductController::class, 'potentialBundles']);
        Route::get('{productId}/attributes', [ProductController::class, 'attributes']);
        Route::get('{productId}/attributes-grouped', [ProductController::class, 'attributesGrouped']);
        // product attributes
        Route::put('{productId}/attributes', [ProductAttributeController::class, 'update']);
        Route::delete('{productId}/attributes', [ProductAttributeController::class, 'delete']);
        // bulk operations
        Route::delete('/', [ProductController::class, 'bulkDestroy']);
        Route::put('/archive', [ProductController::class, 'bulkArchive']);
        Route::put('/unarchive', [ProductController::class, 'bulkUnArchive']);
    });

    /**
     * Product Brands Group.
     */
    Route::prefix('product-brands')->name('product-brands.')->group(function () {
        Route::put('{id}/archive', [ProductBrandController::class, 'archive'])->name('archive');
        Route::put('{id}/unarchived', [ProductBrandController::class, 'unarchived'])->name('unarchived');

        Route::delete('/', [ProductBrandController::class, 'bulkDestroy']);
        Route::put('/archive', [ProductBrandController::class, 'bulkArchive']);
        Route::put('/unarchive', [ProductBrandController::class, 'bulkUnArchive']);
        Route::post('/deletable', [ProductBrandController::class, 'isDeletable']);

        // Import
        Route::post('/import/preview', [ProductBrandController::class, 'previewImport']);
        Route::post('/import', [ProductBrandController::class, 'import']);
    });
    Route::resource('product-brands', ProductBrandController::class);

    /**
     * Attributes.
     */
    Route::prefix('attributes')->name('attributes.')->group(function () {
        Route::put('{attributeId}/archive', [AttributeController::class, 'archive']);
        Route::put('{attributeId}/unarchived', [AttributeController::class, 'unarchived']);
        Route::get('grouped', [AttributeController::class, 'grouped']);

        // bulk
        Route::delete('/', [AttributeController::class, 'bulkDestroy']);
        Route::put('/archive', [AttributeController::class, 'bulkArchive']);
        Route::put('/unarchive', [AttributeController::class, 'bulkUnArchive']);
        Route::post('/deletable', [AttributeController::class, 'isDeletable']);

        // Import
        Route::post('/import/preview', [AttributeController::class, 'previewImport']);
        Route::post('/import', [AttributeController::class, 'import']);
    });
    Route::resource('attributes', AttributeController::class)->except('edit', 'create');

    Route::resource('financial-line-types', FinancialLineTypeController::class)->except('edit', 'create');

    /**
     * Sales Orders Group.
     */
    Route::prefix('sales-orders')->name('sales-orders.')->group(function () {
        Route::put('{salesOrderId}/archive', [SalesOrderController::class, 'archive']);
        Route::put('{salesOrderId}/unarchived', [SalesOrderController::class, 'unarchived']);
        Route::get('constants', [SalesOrderController::class, 'constants']);
        Route::get('orders-have-unallocated-item/{salesOrderId}/{productId}',
            [SalesOrderController::class, 'getOrdersHaveUnallocatedItem']);
        Route::get('next-customer-reference', [SalesOrderController::class, 'getNextLocalNumber']);
        Route::post('{salesOrder}/duplicate', [SalesOrderController::class, 'duplicate']);
        Route::post('{sales_order}/resend', [SalesOrderController::class, 'resend'])->name('resend');
        Route::post('{sales_order}/exchange', [SalesOrderController::class, 'exchange'])->name('exchange');
        Route::post('{sales_order}/dropship-request', [DropshipController::class, 'store'])->name('dropship');
        Route::post('{sales_order}/fulfill', [SalesOrderController::class, 'fulfill'])->name('fulfill');
        Route::post('{sales_order}/fulfill-fba', [SalesOrderController::class, 'fulfillFBA']);
        Route::post('{sales_order}/notes', [SalesOrderController::class, 'addNote']);
        Route::get('{sales_order}/notes', [SalesOrderController::class, 'notes']);
        Route::delete('{sales_order}/notes/{noteId}', [SalesOrderController::class, 'deleteNote']);
        Route::get('{sales_order}/document', [SalesOrderController::class, 'showDocument']);
        Route::get('{sales_order}/shipstation-order', [SalesOrderController::class, 'shipstationOrder']);
        Route::get('{salesOrderFulfillment}/shipstation-fulfillment',
            [SalesOrderController::class, 'shipstationFulfillment']);
        Route::put('{salesOrderId}/mark-as-printed', [SalesOrderController::class, 'markAsPrinted']);
        Route::get('{salesOrder}/compare-fulfillments-with-sales-channel',
            [SalesOrderController::class, 'compareFulfillmentsWithSalesChannel']);

        // Bulk operations
        Route::delete('/', [SalesOrderController::class, 'bulkDestroy']);
        Route::put('/archive', [SalesOrderController::class, 'bulkArchive']);
        Route::put('/unarchive', [SalesOrderController::class, 'bulkUnArchive']);
        Route::post('/deletable', [SalesOrderController::class, 'isDeletable']);
        Route::post('/fulfill', [SalesOrderController::class, 'bulkFulfill'])->name('bulk-fulfill');
        Route::post('/approve', [SalesOrderController::class, 'bulkApprove']);

        // Financial Lines
        Route::resource('{salesOrder}/financial-lines', SalesOrderFinancialLineController::class)->names([
            'index' => 'financial-lines.index',
            'store' => 'financial-lines.store',
            'update' => 'financial-lines.update',
            'destroy' => 'financial-lines.destroy',
        ])->except(['edit', 'create']);
    });
    Route::resource('sales-orders', SalesOrderController::class)->except('edit', 'create');

    /**
     * Purchase Order Notes.
     */
    Route::prefix('purchase-orders')->name('purchase-orders.')->group(function () {
        Route::post('{purchase_order}/notes', [PurchaseOrderController::class, 'addNote']);
        Route::get('{purchase_order}/notes', [PurchaseOrderController::class, 'notes']);
        Route::delete('{purchase_order}/notes/{noteId}', [PurchaseOrderController::class, 'deleteNote']);
    });

    /**
     * Sales Order Lines Group.
     */
    Route::prefix('sales-order-lines')->name('sales-order-lines.')->group(function () {
        Route::post('/{salesOrderLine}/{financialLineType}/convert-to-financial-line',
            [SalesOrderLineController::class, 'convertToFinancialLine'])->name('convert-to-financial-line');
        Route::get('/{salesOrderLineId}', [SalesOrderLineController::class, 'show']);
        Route::put('{sales_order_line}/make-as-non-product', [SalesOrderLineController::class, 'markAsNonProduct']);
        Route::put('{sales_order_line}/map', [SalesOrderLineController::class, 'mapToProduct']);
        Route::post('/import', [SalesOrderLineController::class, 'importLineItemsCsv']);
        Route::post('/reservations', [SalesOrderLineController::class, 'reservations']);
        Route::delete('/', [SalesOrderLineController::class, 'destroyLine']);
    });

    /**
     * Sales Order Fulfillment Group.
     */
    Route::prefix('sales-order-fulfillments')->name('sales-order-fulfillments.')->group(function () {
        Route::put('{salesOrderFulfillmentId}/archive', [SalesOrderFulfillmentController::class, 'archive']);
        Route::put('{salesOrderFulfillmentId}/unarchived', [SalesOrderFulfillmentController::class, 'unarchived']);
        Route::put('{salesOrderFulfillmentId}/mark-as-printed',
            [SalesOrderFulfillmentController::class, 'markAsPrinted']);

        // fulfillment types report
        Route::get('{fulfillment_type}', [SalesOrderFulfillmentController::class, 'report'])->where('fulfillment_type',
            implode('|', SalesOrderFulfillment::TYPES));

        // Bulk operations
        Route::delete('/', [SalesOrderFulfillmentController::class, 'bulkDestroy']);
        Route::put('/archive', [SalesOrderFulfillmentController::class, 'bulkArchive']);
        Route::put('/unarchive', [SalesOrderFulfillmentController::class, 'bulkUnArchive']);
        Route::post('/deletable', [SalesOrderFulfillmentController::class, 'isDeletable']);
        Route::put('/tracking-updates', [SalesOrderFulfillmentController::class, 'bulkRequestTrackingUpdates']);
    });
    Route::resource('sales-order-fulfillments', SalesOrderFulfillmentController::class)->except(['create', 'edit']);

    /**
     * Accounting Group.
     */
    Route::prefix('accounting')->name('accounting.')->group(function () {
        Route::get('/integration', [AccountingIntegrationController::class, 'index']);
        Route::prefix('transactions')->name('transactions.')->group(function () {
            Route::post('/sync-external', [AccountingTransactionController::class, 'syncExternal']);
            Route::post('/delete-integration-payments',
                [AccountingTransactionController::class, 'deleteIntegrationPayments']);
            Route::post('sync-all', [AccountingTransactionController::class, 'syncAll'])->name('sync-all');
            Route::post('/refresh', [AccountingTransactionController::class, 'refresh']);
            Route::get('/{id}', [AccountingTransactionController::class, 'show']);
            Route::post('/unlink-from-integration', [AccountingTransactionController::class, 'unlinkFromIntegration']);
            Route::post('/clear-errors', [AccountingTransactionController::class, 'clearErrors']);
            Route::delete('/', [AccountingTransactionController::class, 'bulkDestroy']);
            Route::post('/bulk-replace-nominal-codes', [AccountingTransactionController::class, 'bulkReplaceNominalCodes'])->name('bulkReplaceNominalCodes');
            Route::post('/bulk-enable-sync', [AccountingTransactionController::class, 'bulkEnableSync'])->name('bulk-enable-sync');
        });
        Route::resource('transactions', AccountingTransactionController::class);

        Route::prefix('payments')->name('payments.')->group(function () {
            Route::post('/sync-external', [AccountingPaymentController::class, 'syncExternal']);
            Route::post('/delete-integration-payments',
                [AccountingPaymentController::class, 'deleteIntegrationPayments']);
            Route::apiResource('/', AccountingPaymentController::class);
        });
    });

    /**
     * Get Suppliers.
     */
    Route::get('suppliers', [SupplierController::class, 'index']);

    /**
     * Get Warehouses.
     */
    Route::get('warehouses', [WarehouseController::class, 'index']);

    /**
     * Get Nominal Codes.
     */
    Route::get('nominal-codes', [NominalCodeController::class, 'index']);

    /**
     * Data Fees.
     */
    Route::resource('data-feeds', DataFeedController::class)->only([
        'index',
    ]);

    // Last Mapping
    Route::get('/import/{model}/last-mappings', [ImportMappingController::class, 'forModel']);
    Route::post('/import/{integrationInstance}/{model}/mappings', [ImportMappingController::class, 'updateMapping']);
    /**
     * Products.
     */
    Route::prefix('products')->name('products.')->group(function () {
        Route::get('{productId}/inventory-movements', [ProductController::class, 'inventoryMovements']);
        Route::get('{productId}/inventory', [ProductController::class, 'inventory']);
        Route::get('{warehouseId}/{productId}/inventory-fba', [ProductController::class, 'inventoryFBA']);
        Route::get('{productId}/initial-inventory', [ProductController::class, 'initialInventory']);
        Route::put('{productId}/set-default-supplier/{supplierId}', [ProductController::class, 'setDefaultSupplier']);
        Route::put('{productId}/assign-attribute-groups', [ProductController::class, 'assignAttributeGroups']);

        Route::get('/{product}/images', [ProductImageController::class, 'index']);
        Route::post('/{product}/images', [ProductImageController::class, 'store']);
        Route::post('/{product}/bulk-images', [ProductImageController::class, 'bulkUpdateCreate']);

        Route::post('/is-deletable', [ProductController::class, 'isProductDeletable']);

        // Product FIFO Layers
        Route::get('{productId}/fifo-layers', [FifoLayerController::class, 'fetchForProduct']);

        Route::get('{product}/listings', [ProductListingsController::class, 'index']);

        // Blemished
        Route::resource('blemished', BlemishedProductController::class)->only(['store']);
        Route::get('/generate-sku-pattern/{product}', [BlemishedProductController::class, 'generateSkuPattern'])->name('generate-sku-pattern');
        // Common Attributes of children for matrix product
        Route::get('/{product}/variations/attributes', [ProductVariationController::class, 'attributes']);

        // Get all attributes of the products provided in the product ids (query param)
        Route::get('/attributes', [ProductVariationController::class, 'allForProducts']);

        // Variations for matrix product
        Route::get('/{product}/variations', [ProductVariationController::class, 'variationsForProduct']);

        // Import
        Route::post('/import/preview', [ProductController::class, 'previewImport']);
        Route::post('/import', [ProductController::class, 'import']);
    });
    Route::resource('products', ProductController::class);

    Route::prefix('initial-inventory')->name('initial-inventory.')->group(function () {
        Route::post('import', [InitialInventoryController::class, 'import'])->name('import');
        Route::resource('/', InitialInventoryController::class);
    });

    //Notes
    Route::resource('notes', NoteController::class)->only('store', 'index', 'destroy');

    Route::apiResource('product-listings', ProductListingsController::class)->only(['show', 'update']);

    // FIFO Layers
    Route::prefix('fifo-layers')->name('fifo-layers.')->group(function () {
        Route::put('{fifoLayer}/archive', [FifoLayerController::class, 'archive']);
        Route::put('{fifoLayer}/unarchived', [FifoLayerController::class, 'unarchived']);

        Route::get('{fifoLayer}/inventory-movements', [FifoLayerController::class, 'inventoryMovements']);

        // Bulk Operations
        Route::put('/archive', [FifoLayerController::class, 'bulkArchive']);
        Route::put('/unarchive', [FifoLayerController::class, 'bulkUnArchive']);
        Route::post('/archivable', [FifoLayerController::class, 'isArchivable']);

        Route::post('/recalculate-total-costs', [FifoLayerController::class, 'recalculateTotalCosts']);
    });
    // FIFO Layers
    Route::resource('fifo-layers', FifoLayerController::class)->only(['show', 'index']);

    /**
     * Backorder Queues.
     */
    Route::prefix('backorder-queues')->name('backorder-queues.')->group(function () {
        Route::put('{backorderQueue}/archive', [BackorderQueueController::class, 'archive']);
        Route::put('{backorderQueue}/unarchived', [BackorderQueueController::class, 'unarchived']);

        Route::post('{backorderQueue}/reorder', [BackorderQueueController::class, 'reorder']);
        Route::put('{backorderQueue}/switch-supplier', [BackorderQueueController::class, 'switchSupplier']);
        Route::get('{backorderQueue}/history', [BackorderQueueController::class, 'history']);
        Route::post('supplier-availability', [BackorderQueueController::class, 'supplierAvailability']);
        Route::post('reorder-bulk', [BackorderQueueController::class, 'reorderBulk']);
        Route::post('releases/{backorderQueueRelease}/re-allocate',
            [BackorderQueueController::class, 'reallocateRelease'])->name('reallocate-release');
        Route::put('/switch-suppliers', [BackorderQueueController::class, 'switchSuppliers']);

        // Bulk Operations
        Route::put('/archive', [BackorderQueueController::class, 'bulkArchive']);
        Route::put('/unarchive', [BackorderQueueController::class, 'bulkUnArchive']);
    });
    // Backorder Queues
    Route::resource('backorder-queues', BackorderQueueController::class)->only(['show', 'index']);

    /**
     * Inventory Management Group.
     */
    Route::prefix('inventory-management')->name('inventory-management.')->group(function () {
        Route::get('aging-inventory', [ReportingController::class, 'agingInventory']);
        Route::get('valuation', [ReportingController::class, 'valuation']);
        Route::get('valuation-by-product', [ReportingController::class, 'valuationByProduct']);
    });
    Route::get('inventory-movements', [InventoryManagementController::class, 'index']);
    Route::get('inventory-movements/tallies', [InventoryManagementController::class, 'tallies']);

    // Inventory Adjustments
    Route::prefix('inventory-adjustments')->name('inventory-adjustments.')->group(function () {
        Route::put('{adjustment}/archive', [InventoryAdjustmentController::class, 'archive']);
        Route::put('{adjustment}/unarchived', [InventoryAdjustmentController::class, 'unarchived']);
        // Bulk Operations
        Route::put('/archive', [InventoryAdjustmentController::class, 'bulkArchive']);
        Route::put('/unarchive', [InventoryAdjustmentController::class, 'bulkUnArchive']);
        Route::delete('/', [InventoryAdjustmentController::class, 'bulkDestroy']);
        Route::post('/deletable', [InventoryAdjustmentController::class, 'isDeletable']);
    });
    Route::resource('inventory-adjustments', InventoryAdjustmentController::class)->except(['edit', 'create']);

    // Inventory Forecast
    Route::get('inventory/forecast', [InventoryForecastController::class, 'index']);
    Route::get('inventory/forecast/status', [InventoryForecastController::class, 'status']);
    Route::get('inventory/forecast/total-cost', [InventoryForecastController::class, 'getTotalCost']);
    Route::post('inventory/forecast/refresh', [InventoryForecastController::class, 'refresh']);
    Route::post('inventory/forecast/purchase-orders', [InventoryForecastController::class, 'createPurchaseOrders']);

    // Images
    Route::prefix('product-images')->name('product-images.')->group(function () {
        Route::put('/{productImage}', [ProductImageController::class, 'update']);
        Route::delete('/{productImage}', [ProductImageController::class, 'destroy']);
    });
    Route::post('store-image', [ProductImageController::class, 'storeImageToServer']);
    Route::delete('delete-image', [ProductImageController::class, 'deleteImageFromServer']);

    // Stock Take
    Route::prefix('stock-takes')->name('stock-takes.')->group(function () {
        Route::post('/{stockTake}/initiate', [StockTakeController::class, 'initiate'])->name('initiate');
        Route::post('/{stockTake}/finalize', [StockTakeController::class, 'finalize'])->name('finalize');
        Route::post('/{stockTake}/revert-to-draft', [StockTakeController::class, 'revertToDraft']);
        Route::put('{stockTake}/archive', [StockTakeController::class, 'archive']);
        Route::put('{stockTake}/unarchived', [StockTakeController::class, 'unarchived']);
        // bulk
        Route::put('/archive', [StockTakeController::class, 'bulkArchive']);
        Route::put('/unarchive', [StockTakeController::class, 'bulkUnArchive']);
        Route::delete('/', [StockTakeController::class, 'bulkDestroy']);
        Route::post('/deletable', [StockTakeController::class, 'isDeletable']);
        Route::post('{stockTake}/import-lines', [StockTakeController::class, 'importStockTakeLines']);

        Route::post('/bulk-insert', [StockTakeController::class, 'bulkInsert']);
    });
    Route::resource('/stock-takes', StockTakeController::class)->except('create', 'edit');

    // Inventory Assembly
    Route::prefix('assemblies')->name('assemblies.')->group(function () {
        Route::put('{assembly}/archive', [InventoryAssemblyController::class, 'archive']);
        Route::put('{assembly}/unarchived', [InventoryAssemblyController::class, 'unarchived']);
        // bulk
        Route::put('/archive', [InventoryAssemblyController::class, 'bulkArchive']);
        Route::put('/unarchive', [InventoryAssemblyController::class, 'bulkUnArchive']);
        Route::delete('/', [InventoryAssemblyController::class, 'bulkDestroy']);
        Route::post('/deletable', [InventoryAssemblyController::class, 'isDeletable']);
    });

    Route::resource('assemblies', InventoryAssemblyController::class)->only([
        'index',
        'store',
        'show',
        'destroy',
        'update',
    ]);

    // Data Feeds
    Route::prefix('data-feeds')->name('data-feeds.')->group(function () {
        //Single
        Route::put('{dataFeed}/archive', [DataFeedController::class, 'archive']);
        Route::put('{dataFeed}/unarchived', [DataFeedController::class, 'unarchived']);

        //Bulk
        Route::post('deletable', [DataFeedController::class, 'isDeletable']);
        Route::put('archive', [DataFeedController::class, 'bulkArchive']);
        Route::put('unarchive', [DataFeedController::class, 'bulkUnarchive']);
        Route::delete('/', [DataFeedController::class, 'bulkDestroy']);

        Route::get('import-config/{dataFeed}', [DataFeedController::class, 'importConfig']);
    });
    Route::resource('/data-feeds', DataFeedController::class)->only(['index', 'store', 'destroy', 'update', 'show']);

    /**
     * Connections.
     */
    Route::post('connection/check-ftp', [ConnectionController::class, 'checkFtp']);

    /**
     * Product Pricing Tiers.
     */
    Route::prefix('product-pricing-tiers')->name('product-pricing-tiers.')->group(function () {
        Route::put('{productPricingTier}/archive', [ProductPricingTierController::class, 'archive']);
        Route::put('{productPricingTier}/unarchived', [ProductPricingTierController::class, 'unarchived']);
        Route::put('{productPricingTier}/default', [ProductPricingTierController::class, 'setAsDefault']);

        // bulk
        Route::put('/archive', [ProductPricingTierController::class, 'bulkArchive']);
        Route::put('/unarchive', [ProductPricingTierController::class, 'bulkUnArchive']);
        Route::delete('/', [ProductPricingTierController::class, 'bulkDestroy']);
        Route::post('/deletable', [ProductPricingTierController::class, 'isDeletable']);
        Route::post('/archivable', [ProductPricingTierController::class, 'isArchivable']);

        // Import
        Route::post('/import/preview', [ProductPricingTierController::class, 'previewImport']);
        Route::post('/import', [ProductPricingTierController::class, 'import']);
    });
    Route::resource('product-pricing-tiers', ProductPricingTierController::class);

    /**
     * Purchase Orders Group.
     */
    Route::prefix('purchase-orders')->name('purchase-orders.')->group(function () {
        Route::put('{purchase_order}/submit', [PurchaseOrderController::class, 'submit']);
        Route::post('{purchase_order}/duplicate', [PurchaseOrderController::class, 'duplicate'])->name('duplicate');
        Route::post('{purchase_order}/receiving-discrepancy', [PurchaseOrderController::class, 'createReceivingDiscrepancy'])->name('create-receiving-discrepancy');
        Route::post('import', [PurchaseOrderController::class, 'importCSV']);
        Route::get('{purchase_order}/dropship-shipments', [PurchaseOrderController::class, 'dropshipShipments']);
        Route::get('{purchase_order}/receipts', [PurchaseOrderShipmentController::class, 'receipts']);
        Route::get('{purchase_order}/receipts/{receipt}', [PurchaseOrderShipmentController::class, 'getReceipt']);
        Route::get('{purchase_order}/invoice/preview', [PurchaseOrderController::class, 'previewInvoice']);

        // Dropship (create purchase order shipment)
        Route::post('{purchase_order}/dropship', [DropshipController::class, 'ship'])->name('dropship');

        // Purchase order invoices
        Route::get('{purchaseOrder}/invoices', [PurchaseInvoiceController::class, 'index']);

        // Bulk operations
        Route::delete('/', [PurchaseOrderController::class, 'bulkDestroy']);
        Route::put('/archive', [PurchaseOrderController::class, 'bulkArchive']);
        Route::put('/unarchive', [PurchaseOrderController::class, 'bulkUnArchive']);
        Route::post('/deletable', [PurchaseOrderController::class, 'isDeletable']);
        Route::post('/approve', [PurchaseOrderController::class, 'bulkApprove']);
        Route::post('/submit', [PurchaseOrderController::class, 'bulkSubmit']);

        // Import
        Route::post('/import/preview', [PurchaseOrderController::class, 'previewImport']);
        Route::post('/import', [PurchaseOrderController::class, 'import']);

        // Builder
        Route::post('/build', [PurchaseOrderBuilderController::class, 'build']);
        Route::post('/build-export', [PurchaseOrderBuilderController::class, 'export']);

        // Purchase order lines
        Route::post('/import-lines', [PurchaseOrderLineController::class, 'importLineItemsCsv']);

        // Apply to lines
        Route::post('{purchaseOrder}/apply-discount-rate', ApplyPurchaseOrderDiscountLinesController::class);
        Route::post('{purchaseOrder}/apply-pricing-tier/{supplierPricingTier}',
            ApplyPurchaseOrderPricingTierController::class);
        Route::post('{purchase_order}/asn', [AdvancedShipmentNoticeController::class, 'sendForPurchaseOrder'])->name('asn');
    });
    Route::resource('purchase-orders', PurchaseOrderController::class)->except(['edit', 'create']);
    Route::get('purchase-orders/{purchase_order}/lines', [PurchaseOrderLineController::class, 'getLines']);

    /**
     * Purchase Order Shipments.
     */
    Route::post('purchase-order-shipments/receive', [PurchaseOrderShipmentController::class, 'receive']);
    Route::put('purchase-order-shipments/receipts/{receipt}',
        [PurchaseOrderShipmentController::class, 'updateReceipt']);
    Route::put('purchase-order-shipments/receipts/{receipt}/delete-lines',
        [PurchaseOrderShipmentController::class, 'deleteReceiptLines']);
    Route::delete('purchase-order-shipments/receipts/{receipt}',
        [PurchaseOrderShipmentController::class, 'deleteReceipt'])->name('purchase-order-shipments.delete-receipt');
    Route::resource('purchase-order-shipments', PurchaseOrderShipmentController::class)->only(['store', 'update']);

    /**
     * Purchase Invoices Group.
     */
    Route::prefix('purchase-invoices')->name('purchase-invoices.')->group(function () {
        Route::post('fees-received', [PurchaseInvoiceController::class, 'storeCustom']);

        // Bulk operations
        Route::delete('/', [PurchaseInvoiceController::class, 'bulkDestroy']);
        Route::post('/deletable', [PurchaseInvoiceController::class, 'isDeletable']);

        Route::prefix('{purchaseInvoiceId}')->name('purchase-invoices.payments')->group(function () {
            Route::resource('/payments', PurchaseInvoicePaymentController::class);
        });
    });
    Route::resource('purchase-invoices', PurchaseInvoiceController::class)->only('store', 'update', 'destroy');

    /**
     * Supplier Products.
     */
    Route::resource('supplier-products', SupplierProductController::class)->except('index', 'create', 'edit');

    /**
     * Supplier Pricing Tiers.
     */
    Route::prefix('supplier-pricing-tiers')->name('supplier-pricing-tiers.')->group(function () {
        Route::put('{supplierPricingTier}/archive', [SupplierPricingController::class, 'archive']);
        Route::put('{supplierPricingTier}/unarchived', [SupplierPricingController::class, 'unarchived']);
        Route::put('{supplierPricingTier}/default', [SupplierPricingController::class, 'setAsDefault']);

        // bulk
        Route::put('/archive', [SupplierPricingController::class, 'bulkArchive']);
        Route::put('/unarchive', [SupplierPricingController::class, 'bulkUnArchive']);
        Route::delete('/', [SupplierPricingController::class, 'bulkDestroy']);
        Route::post('/deletable', [SupplierPricingController::class, 'isDeletable']);
        Route::post('/archivable', [SupplierPricingController::class, 'isArchivable']);

        // Import
        Route::post('/import/preview', [SupplierPricingController::class, 'previewImport']);
        Route::post('/import', [SupplierPricingController::class, 'import']);
    });
    Route::resource('supplier-pricing-tiers', SupplierPricingController::class)->except(['edit', 'create']);

    /**
     * Supplier Inventory.
     */
    Route::prefix('supplier-inventories')->name('supplier-inventories.')->group(function () {
        Route::put('{inventory}/archive', [SupplierInventoryController::class, 'archive']);
        Route::put('{inventory}/unarchived', [SupplierInventoryController::class, 'unarchived']);
        Route::post('{supplier}/import', [SupplierInventoryController::class, 'importCSV']);

        // bulk
        Route::put('/archive', [SupplierInventoryController::class, 'bulkArchive']);
        Route::put('/unarchive', [SupplierInventoryController::class, 'bulkUnArchive']);
        Route::post('/deletable', [SupplierInventoryController::class, 'isDeletable']);
        Route::post('/archivable', [SupplierInventoryController::class, 'isArchivable']);
    });
    Route::resource('supplier-inventories', SupplierInventoryController::class)->except([
        'edit',
        'create',
        'destroy',
        'store',
    ]);

    // Report templates
    Route::resource('report-templates', ReportTemplateController::class)->except(['edit', 'show']);

    /**
     * Warehouses Group.
     */
    Route::prefix('warehouses')->name('warehouses.')->group(function () {
        // Incoming Purchase Orders
        Route::get('{warehouse}/incoming-purchase-orders', [WarehouseController::class, 'incomingPurchaseOrders']);
        // Inventory Summary
        Route::get('{warehouse}/inventory-summary', [WarehouseDashboardController::class, 'inventorySummary']);
        // Inventory Activity
        Route::get('{warehouse}/inventory-activity', [WarehouseDashboardController::class, 'inventoryActivity']);
        // Shipments
        Route::get('{warehouse}/inventory-shipments', [WarehouseDashboardController::class, 'inventoryShipments']);

        Route::prefix('transfers')->name('transfers.')->group(function () {
            // Warehouse Transfers
            Route::post('deletable', [WarehouseTransferController::class, 'isDeletable']);
            Route::put('{transfer}/archive', [WarehouseTransferController::class, 'archive']);
            Route::put('{transfer}/unarchived', [WarehouseTransferController::class, 'unarchived']);

            ROute::post('{transfer}/receiving-discrepancy', [WarehouseTransferController::class, 'createReceivingDiscrepancy'])->name('create-receiving-discrepancy');

            // Bulk Actions
            Route::put('/archive', [WarehouseTransferController::class, 'bulkArchive']);
            Route::put('/unarchive', [WarehouseTransferController::class, 'bulkUnArchive']);
            Route::delete('/', [WarehouseTransferController::class, 'bulkDestroy']);
            Route::post('/deletable', [WarehouseTransferController::class, 'isDeletable']);
            Route::post('/import-lines', [WarehouseTransferController::class, 'importLinesCsv'])->name('import-lines');

            Route::put('{transfer}/open', [WarehouseTransferController::class, 'openWarehouseTransfer'])->name('open');
            Route::put('{transfer}/draft', [WarehouseTransferController::class, 'makeWarehouseTransferDraft']);
            Route::post('{transfer}/duplicate', [WarehouseTransferController::class, 'duplicate']);
            Route::post('{transfer}/notes', [WarehouseTransferNoteController::class, 'addNote']);
            Route::get('{transfer}/notes', [WarehouseTransferNoteController::class, 'notes']);
            Route::delete('{transfer}/notes/{noteId}', [WarehouseTransferNoteController::class, 'deleteNote']);
            //    Route::put( '{transfer}/shipment', [WarehouseTransferController::class, 'createShipment'] );
            Route::get('{transfer}/receipts', [WarehouseTransferShipmentController::class, 'receipts']);
            Route::post('{transfer}/receive', [WarehouseTransferShipmentController::class, 'receiveShipment'])->name('receive');
            Route::put('{transfer}/receipts/{receipt}', [WarehouseTransferShipmentController::class, 'updateReceipt'])->name('update-receipt');
            Route::delete('{transfer}/receipts/{receipt}',
                [WarehouseTransferShipmentController::class, 'deleteReceipt'])->name('delete-receipt');
            Route::post('{warehouseTransfer}/asn', [\App\Http\Controllers\AdvancedShipmentNoticeController::class, 'sendForWarehouseTransfer'])->name('asn');
            Route::patch('{warehouseTransfer}/lines', [WarehouseTransferController::class, 'updateWarehouseTransferLines'])->name('lines');
        });
        Route::resource('transfers', WarehouseTransferController::class)->only([
            'index',
            'store',
            'show',
            'destroy',
            'update',
        ]);

        Route::put('{warehouse}/archive', [WarehouseController::class, 'archive']);
        Route::put('{warehouse}/unarchived', [WarehouseController::class, 'unarchived']);

        // bulk
        Route::delete('/', [WarehouseController::class, 'bulkDestroy']);
        Route::put('/archive', [WarehouseController::class, 'bulkArchive']);
        Route::put('/unarchive', [WarehouseController::class, 'bulkUnArchive']);
        Route::post('/deletable', [WarehouseController::class, 'isDeletable']);
        Route::post('is-archivable', [WarehouseController::class, 'isArchivable']);
        // Import
        Route::post('/import/preview', [WarehouseController::class, 'previewImport']);
        Route::post('/import', [WarehouseController::class, 'import']);

        Route::get('automated', [WarehouseController::class, 'automatedWarehouses']);
    });
    Route::resource('warehouses', WarehouseController::class)->only(['index', 'store', 'update', 'show', 'destroy']);

    /**
     * Warehouse locations Group.
     */
    Route::get('warehouse-locations/{warehouse}', [WarehouseLocationController::class, 'index']);
    Route::resource('warehouse-locations', WarehouseLocationController::class)->only(['store', 'update']);

    /**
     * Store Email Templates Group.
     */
    Route::post('store-email-templates/preview', [StoreEmailTemplateController::class, 'preview']);
    Route::get('store-email-templates/user-templates', [StoreEmailTemplateController::class, 'userTemplates'])->name('store-email-templates.user-templates');
    Route::post('store-email-templates/send', [StoreEmailTemplateController::class, 'send'])->name('store-email-templates.send');
    Route::skuResource('store-email-templates', StoreEmailTemplateController::class);

    /**
     * Stores Group.
     */
    Route::prefix('stores')->name('stores.')->group(function () {
        Route::put('{store}/archive', [StoreController::class, 'archive']);
        Route::put('{store}/unarchived', [StoreController::class, 'unarchived']);

        // bulk
        Route::put('/archive', [StoreController::class, 'bulkArchive']);
        Route::put('/unarchive', [StoreController::class, 'bulkUnArchive']);
        Route::delete('/', [StoreController::class, 'bulkDestroy']);
        Route::post('/deletable', [StoreController::class, 'isDeletable']);

        // Import
        Route::post('/import/preview', [StoreController::class, 'previewImport']);
        Route::post('/import', [StoreController::class, 'import']);
    });
    Route::resource('stores', StoreController::class)->except(['create', 'edit']);

    /**
     * Sales Credit.
     */
    Route::prefix('sales-credits')->name('sales-credits.')->group(function () {
        Route::get('{sales_credit}/invoice/preview', [SalesCreditController::class, 'previewInvoice']);
        Route::post('/receive', [SalesCreditController::class, 'receive'])->name('receive');
        Route::post('/paid', [SalesCreditController::class, 'paid'])->name('paid');
        Route::put('{sales_credit}/archive', [SalesCreditController::class, 'archive']);
        Route::put('{sales_credit}/unarchived', [SalesCreditController::class, 'unarchived']);
        Route::delete('/return-lines/{sales_credit_return_line}', [SalesCreditController::class, 'destroyReturnLine']);

        // bulk
        Route::put('/archive', [SalesCreditController::class, 'bulkArchive']);
        Route::put('/unarchive', [SalesCreditController::class, 'bulkUnArchive']);
        Route::post('/deletable', [SalesCreditController::class, 'isDeletable']);
        Route::delete('/', [SalesCreditController::class, 'bulkDestroy']);

        // Notes
        Route::post('{salesCredit}/notes', [SalesCreditController::class, 'addNote']);
        Route::get('{salesCredit}/notes', [SalesCreditController::class, 'notes']);
        Route::delete('{salesCredit}/notes/{noteId}', [SalesCreditController::class, 'deleteNote']);

        // Payments
        Route::put('/{salesCredit}/payments/{payment}', [SalesCreditPaymentController::class, 'updatePayment']);
        Route::delete('/{salesCredit}/payments/{payment}', [SalesCreditPaymentController::class, 'deletePayment']);
    });
    Route::resource('sales-credits', SalesCreditController::class)->except(['edit', 'create']);

    /**
     * Shipping Providers Group.
     */
    Route::prefix('shipping-providers')->name('shipping-providers.')->group(function () {
        // integration instance as shipping provider
        Route::get('{integration_instance}/shipping-methods', [ShippingProviderController::class, 'shippingMethods']);
        Route::get('{integration_instance}/shipping-method-count',
            [ShippingProviderController::class, 'shippingMethodSalesOrdersCount']);
        Route::put('{integration_instance}/map-shipping-methods',
            [ShippingProviderController::class, 'mapShippingMethods']);
        Route::delete('{integration_instance}/destroy-shipping-method/{mapping_id}',
            [ShippingProviderController::class, 'destroyShippingMapping']);
    });
    Route::resource('shipping-providers', ShippingProviderController::class)->except('destroy');

    /**
     * User API Group.
     */
    Route::resource('user-api', UserApiController::class)->only(['index', 'store', 'destroy']);

    /**
     * Nominal Codes Group.
     */
    Route::prefix('nominal-codes')->name('nominal-codes.')->group(function () {
        Route::put('{nominalCode}/archive', [NominalCodeController::class, 'archive']);
        Route::put('{nominalCode}/unarchived', [NominalCodeController::class, 'unarchived']);

        // Bulk
        Route::delete('/', [NominalCodeController::class, 'bulkDestroy']);
        Route::put('/archive', [NominalCodeController::class, 'bulkArchive']);
        Route::put('/unarchive', [NominalCodeController::class, 'bulkUnArchive']);
        Route::post('/deletable', [NominalCodeController::class, 'isDeletable']);
        Route::post('/archivable', [NominalCodeController::class, 'isArchivable']);

        // Import
        Route::post('/import/preview', [NominalCodeController::class, 'previewImport']);
        Route::post('/import', [NominalCodeController::class, 'import']);
    });
    Route::resource('nominal-codes', NominalCodeController::class);

    /**
     * Payment Terms Group.
     */
    Route::prefix('payment-terms')->name('payment-terms.')->group(function () {
        Route::put('{paymentTerm}/archive', [PaymentTermController::class, 'archive']);
        Route::put('{paymentTerm}/unarchived', [PaymentTermController::class, 'unarchived']);

        // bulk
        Route::delete('/', [PaymentTermController::class, 'bulkDestroy']);
        Route::put('/archive', [PaymentTermController::class, 'bulkArchive']);
        Route::put('/unarchive', [PaymentTermController::class, 'bulkUnArchive']);
        Route::post('deletable', [PaymentTermController::class, 'isDeletable']);
    });
    Route::resource('payment-terms', PaymentTermController::class);

    /**
     * Payment Types Group.
     */
    Route::prefix('payment-types')->name('payment-types.')->group(function () {
        Route::put('{paymentType}/archive', [PaymentTypeController::class, 'archive']);
        Route::put('{paymentType}/unarchived', [PaymentTypeController::class, 'unarchived']);

        // bulk
        Route::delete('/', [PaymentTypeController::class, 'bulkDestroy']);
        Route::put('/archive', [PaymentTypeController::class, 'bulkArchive']);
        Route::put('/unarchive', [PaymentTypeController::class, 'bulkUnArchive']);
        Route::post('deletable', [PaymentTypeController::class, 'isDeletable']);
        Route::post('accounting-mapping', [PaymentTypeController::class, 'updateAccountingMapping']);
    });
    Route::apiResource('payment-types', PaymentTypeController::class);

    /**
     * Incoterm Group.
     */
    Route::prefix('incoterms')->name('incoterms.')->group(function () {
        Route::put('{incoterm}/archive', [IncotermController::class, 'archive']);
        Route::put('{incoterm}/unarchived', [IncotermController::class, 'unarchived']);

        // bulk operations
        Route::delete('/', [IncotermController::class, 'bulkDestroy']);
        Route::put('/archive', [IncotermController::class, 'bulkArchive']);
        Route::put('/unarchive', [IncotermController::class, 'bulkUnArchive']);
        Route::post('deletable', [IncotermController::class, 'isDeletable']);
    });
    Route::resource('incoterms', IncotermController::class);

    /**
     * Shipping Carriers.
     */
    Route::resource('shipping-carriers', ShippingCarrierController::class)->except(['destroy']);

    /**
     * Shipping Methods.
     */
    Route::prefix('shipping-methods')->name('shipping-methods.')->group(function () {
        Route::put('{shipping_method}/archive', [ShippingMethodController::class, 'archive']);
        Route::put('{shipping_method}/unarchived', [ShippingMethodController::class, 'unarchived']);

        // bulk operations
        Route::put('/archive', [ShippingMethodController::class, 'bulkArchive']);
        Route::put('/unarchive', [ShippingMethodController::class, 'bulkUnArchive']);
        Route::delete('/', [ShippingMethodController::class, 'bulkDestroy']);
        Route::post('deletable', [ShippingMethodController::class, 'isDeletable']);

        // Import
        Route::post('/import/preview', [ShippingMethodController::class, 'previewImport']);
        Route::post('/import', [ShippingMethodController::class, 'import']);
    });
    Route::resource('shipping-methods', ShippingMethodController::class)->except('create', 'edit');

    /**
     * Addresses.
     */
    Route::prefix('addresses')->name('addresses.')->group(function () {
        Route::post('/locked', [AddressController::class, 'isLocked']);
        Route::post('/deletable', [AddressController::class, 'isDeletable']);
    });
    Route::resource('addresses', AddressController::class)->only(['update', 'destroy']);

    /**
     * Table Views.
     */
    Route::resource('table-views', TableViewController::class);
    Route::prefix('table-views')->name('table-views.')->group(function () {
        Route::put('/set-default-view/{viewId}', [TableViewController::class, 'setDefaultView']);
    });

    /**
     * Sales Orders.
     */
    Route::prefix('sales-orders')->name('sales-orders.')->group(function () {
        Route::get('{salesOrderId}/split-by-availability', [SalesOrderController::class, 'splitByAvailability']);
        Route::get('{salesOrderId}/split-by-weight/{maxWeight}', [SalesOrderController::class, 'splitByWeight']);
        Route::get('{salesOrderId}/split-by-supplier', [SalesOrderController::class, 'splitByDefaultSupplier']);
        Route::get('{salesOrderId}/split-one-each-order', [SalesOrderController::class, 'splitOneInEachOrder']);
        Route::get('{salesOrderId}/financials', [SalesOrderController::class, 'financialsProforma']);
        Route::prefix('{salesOrderId}')->name('sales-orders.payments')->group(function () {
            Route::resource('/payments', SalesOrderPaymentController::class);
        });

        // Export
        Route::get('/export', [SalesOrderController::class, 'export']);

        // Import
        Route::post('/import/preview', [SalesOrderController::class, 'previewImport']);
        Route::post('/import', [SalesOrderController::class, 'import']);
    });

    /**
     * Product Taxonomy.
     */
    // Categories
    Route::prefix('categories')->name('categories.')->group(function () {
        Route::get('for-manage', [ProductCategoryController::class, 'indexForManage']);
        Route::get('tree', [ProductCategoryController::class, 'indexForTree']);
        Route::post('assign-category-to-product', [ProductCategoryController::class, 'assignToProduct']);
        Route::put('reassign-to-products', [ProductCategoryController::class, 'reassignToProducts']);
        Route::put('{productCategoryId}/archive', [ProductCategoryController::class, 'archive']);
        Route::put('{productCategoryId}/unarchived', [ProductCategoryController::class, 'unarchived']);
        // Bulk operations
        Route::delete('/', [ProductCategoryController::class, 'bulkDestroy']);
        Route::put('/archive', [ProductCategoryController::class, 'bulkArchive']);
        Route::put('/unarchive', [ProductCategoryController::class, 'bulkUnArchive']);
        Route::post('/deletable', [ProductCategoryController::class, 'isDeletable']);

        // Import
        Route::post('/import/preview', [ProductCategoryController::class, 'previewImport']);
        Route::post('/import', [ProductCategoryController::class, 'import']);
    });
    Route::resource('categories', ProductCategoryController::class)->except('create', 'edit');

    // Attribute Groups
    Route::prefix('attribute-groups')->name('attribute-groups.')->group(function () {
        Route::get('for-manage', [AttributeGroupController::class, 'indexForManage']);
        Route::put('{attributeGroup}/archive', [AttributeGroupController::class, 'archive']);
        Route::put('{attributeGroup}/unarchived', [AttributeGroupController::class, 'unarchived']);

        // bulk
        Route::put('/archive', [AttributeGroupController::class, 'bulkArchive']);
        Route::put('/unarchive', [AttributeGroupController::class, 'bulkUnArchive']);
        Route::delete('/', [AttributeGroupController::class, 'bulkDestroy']);
        Route::post('/deletable', [AttributeGroupController::class, 'isDeletable']);

        // Import
        Route::post('/import/preview', [AttributeGroupController::class, 'previewImport']);
        Route::post('/import', [AttributeGroupController::class, 'import']);
    });
    Route::resource('attribute-groups', AttributeGroupController::class)->except('create', 'edit');

    Route::prefix('currencies')->name('currencies.')->group(function () {
        Route::put('{currency}/set-default', [CurrencyController::class, 'setAsDefault'])->name('setAsDefault');
        Route::put('bulk-update', [CurrencyController::class, 'bulkUpdate'])->name('bulkUpdate');
        Route::delete('/', [CurrencyController::class, 'bulkDestroy'])->name('bulkDestroy');
        Route::post('/deletable', [CurrencyController::class, 'isDeletable']);
    });
    Route::resource('currencies', CurrencyController::class)->except('create', 'edit', 'show');

    /**
     * Settings.
     */
    Route::prefix('settings')->name('settings.')->group(function () {
        // mapping nominal codes
        Route::get('mapping-nominal-codes', [SettingController::class, 'nominalCodesMapping']);
        Route::put('mapping-nominal-codes', [SettingController::class, 'updateNominalCodesMapping']);
        // sales orders
        Route::get('sales-orders', [SettingController::class, 'salesOrders']);
        Route::put('sales-orders', [SettingController::class, 'updateSalesOrders']);

        // Purchase orders
        Route::get('purchase-orders', [SettingController::class, 'purchaseOrders']);
        Route::put('purchase-orders', [SettingController::class, 'updatepurchaseOrders']);

        Route::get('warehouse-locations', [SettingController::class, 'getWarehouseLocationSettings']);
        Route::put('warehouse-locations', [SettingController::class, 'updateWarehouseLocationSettings']);

        // inventory forecasting
        Route::get('inventory-forecasting', [SettingController::class, 'inventoryForecasting']);
        Route::put('inventory-forecasting', [SettingController::class, 'updateInventoryForecasting']);

        // Warehouse priorities
        Route::post('warehouse-priority', [SettingController::class, 'setWarehousePriority']);

        // Inventory Start Date
        Route::put('inventory-start-date', [SettingController::class, 'setInventoryStartDate']);
        Route::put('date-setting', [SettingController::class, 'updateDateSettingToUtc']);

        // Auto fulfillment settings
        Route::put('auto-fulfillments', [SettingController::class, 'updateAutoFulfillmentSettings']);

        //Sku Pattern
        Route::get('blemished-sku-pattern', [SettingController::class, 'getBlemishedSkuPattern'])->name('get-blemished-sku-pattern');
        Route::put('blemished-sku-pattern', [SettingController::class, 'updateBlemishedSkuPattern'])->name('update-blemished-sku-pattern');
    });
    Route::resource('settings', SettingController::class)->only('index', 'show', 'update');

    /**
     * Lookup.
     */
    Route::prefix('lookup')->name('lookup.')->group(function () {
        Route::get('accounting-transactions', [LookupController::class, 'accountingTransactions']);
        Route::get('accounting-payments', [LookupController::class, 'accountingPayments']);
        Route::get('products', [LookupController::class, 'products']);
        Route::get('sales-orders', [LookupController::class, 'salesOrders']);
        Route::get('purchase-orders', [LookupController::class, 'purchaseOrders']);
        Route::get('stock-takes', [LookupController::class, 'stockTakes']);
        Route::get('inventory-movements', [LookupController::class, 'inventoryMovements']);
        Route::get('fifo-layers', [LookupController::class, 'fifoLayers']);
        Route::get('backorder-queues', [LookupController::class, 'backorderQueues']);
        Route::get('inventory-adjustments', [LookupController::class, 'inventoryAdjustments']);
        Route::get('integration-instances/{integration_instance}/listings',
            [LookupController::class, 'integrationListings']);
        Route::get('sales-order-fulfillments', [LookupController::class, 'salesOrderFulfillments']);
        Route::get('sales-order-line-financials', [LookupController::class, 'salesOrderLineFinancials']);
        Route::get('ship-by-schedule', [LookupController::class, 'shipBySchedule']);
        Route::get('sales-channels/{sales_channel}/payment-methods',
            [SalesChannelController::class, 'paymentMethodsLookup']);
        Route::get('tags', [LookupController::class, 'tags']);
        Route::get('custom-fields', [LookupController::class, 'customFields']);

    });

    /**
     * Activity.
     */
    Route::prefix('activity')->name('activity.')->group(function () {
        Route::get('/', [ActivityController::class, 'index']);
    });

    /**
     * Tags.
     */
    Route::prefix('tags')->name('tags.')->group(function () {
        // Import
        Route::post('/import/preview', [TagController::class, 'previewImport']);
        Route::post('/import', [TagController::class, 'import']);
    });
    Route::skuResource('tags', TagController::class);

    /**
     * Tax Rates
     */
    Route::prefix('tax-rates')->name('tax-rates.')->group(function () {
        Route::post('accounting-mapping', [TaxRateController::class, 'updateAccountingMapping'])->name('accounting-mapping');
    });
    Route::skuResource('tax-rates', TaxRateController::class);

    /**
     * Return Reasons Group.
     */
    Route::skuResource('return-reasons', ReturnReasonController::class);

    /**
     * Constants APIs. Countries, Currencies and States.
     */
    Route::prefix('constants')->name('constants.')->group(function () {
        Route::get('countries', [ConstantController::class, 'countries']);
        Route::get('countries-grouped', [ConstantController::class, 'countriesGrouped']);
        Route::get('currencies', [ConstantController::class, 'currencies']);
        Route::get('states/{countryCode}', [ConstantController::class, 'states']);
        Route::get('zips/{countryCode}', [ConstantController::class, 'zips']);
        Route::get('get-address/{country_code}/{zip_code}', [ConstantController::class, 'getAddress']);
    });

    Route::get('integrations/{all?}', [IntegrationInstanceController::class, 'integrations']);

    Route::resource('customers', CustomerController::class)->except(['create', 'edit']);
    Route::resource('csv-templates', CsvTemplateController::class)->except('create', 'edit');

    Route::middleware('is_power_user')->group(function () {
        Route::prefix('financials')->name('financials.')->group(function () {
            Route::get('/summary-by-period', [FinancialController::class, 'summaryByPeriod']);
            Route::get('/top-products', [FinancialController::class, 'topProducts']);
            Route::get('/products/{product_id}/summary-by-period',
                [FinancialController::class, 'summaryByProductPeriod']);
            Route::get('/sales-order-lines', [SalesOrderLineFinancialController::class, 'index']);
            Route::resource('/daily-summary', ReportingDailyFinancialController::class);
            Route::post('/sales-order-line-financials/recalculate-lines', [SalesOrderLineFinancialController::class, 'recalculateLines']);
            Route::post('/daily-financials/recalculate', [ReportingDailyFinancialController::class, 'recalculateDailyFinancials']);
        });

        /**
         * Sales Channels resource - Groups.
         */
        Route::prefix('sales-channels')->name('sales-channels.')->group(function () {
            // eBay group
            Route::prefix('ebay')->name('ebay.')->group(function () {
            });

            // shipping methods
            Route::get('{sales_channel}/shipping-methods', [SalesChannelController::class, 'shippingMethods']);
            Route::get('{sales_channel}/shipping-method-count',
                [SalesChannelController::class, 'shippingMethodSalesOrdersCount']);
            Route::put('{sales_channel}/map-shipping-methods', [SalesChannelController::class, 'mapShippingMethods']);
            Route::delete('{sales_channel}/unmap-shipping-method/{method_name}',
                [SalesChannelController::class, 'unmapShippingMethod']);
            // payment methods
            Route::get('{sales_channel}/payment-methods', [SalesChannelController::class, 'paymentMethods']);
            Route::put('{sales_channel}/map-payment-methods', [SalesChannelController::class, 'mapPaymentMethods']);
            Route::delete('payment-method-mapping/{mapping_id}',
                [SalesChannelController::class, 'destroyPaymentMethodMapping']);
            Route::delete('shipping-method-mapping/{mapping_id}',
                [SalesChannelController::class, 'destroyShippingMapping']);
        });

        /**
         * Integrations group.
         */
        Route::prefix('integration-instances')->name('integration-instances.')->group(function () {
            Route::get('{integration_instance}/listings',
                [IntegrationInstanceController::class, 'salesChannelProducts'])->name('listings');
            Route::delete('{integration_instance}/listings/{id}',
                [IntegrationInstanceController::class, 'deleteListing']);
            Route::post('{integration_instance}/listings/create-sku-products',
                [IntegrationInstanceListingController::class, 'listingsToSKUProducts']);
            Route::get('{integration_instance}/listings/mapping-info',
                [IntegrationInstanceListingController::class, 'getMappingInfo']);
            Route::post('{integration_instance}/listings/download',
                [IntegrationInstanceController::class, 'downloadListings'])->name('download-listings');
            Route::get('{integration_instance}/listings/{id}',
                [IntegrationInstanceController::class, 'listingDocumentInSalesChannel']);
            Route::put('{integration_instance}/map-listing', [IntegrationInstanceController::class, 'mapListing']);
            Route::put('{integration_instance}/unmap-listing', [IntegrationInstanceController::class, 'unmapListing']);
            Route::post('{integration_instance}/download-orders', [IntegrationInstanceController::class, 'downloadOrders']);
            Route::get('{integration_instance}/orders', [IntegrationInstanceController::class, 'salesChannelOrders']);
            Route::get('{integration_instance}/orders/{order}',
                [IntegrationInstanceController::class, 'salesChannelOrder']);
            Route::put('{integration_instance}/orders/{order}/archive',
                [IntegrationInstanceController::class, 'archiveSalesChannelOrder']);
            Route::put('{integration_instance}/orders/{order}/unarchived',
                [IntegrationInstanceController::class, 'unarchiveSalesChannelOrder']);
            Route::put('{integration_instance}/orders/archive',
                [IntegrationInstanceController::class, 'bulkArchiveSalesChannelOrder']);
            Route::put('{integration_instance}/orders/unarchived',
                [IntegrationInstanceController::class, 'bulkUnarchiveSalesChannelOrder']);
            Route::put('{integration_instance}/orders/create-sku',
                [IntegrationInstanceController::class, 'CreateSkuOrderFromSalesChannelOrder']);
            Route::post('{integration_instance}/orders/{order}/refresh',
                [IntegrationInstanceController::class, 'refreshWithSalesChannel']);

            Route::post('{integration_instance}/import-mappings', [IntegrationInstanceListingController::class, 'importListingsMappings']);

            Route::get('{integration_instance}/ebay/generate-oauth-url',
                [EBay\EBayIntegrationController::class, 'generateOAuthUrl']);

            // Bulk
            Route::delete('{integration_instance}/listings',
                [IntegrationInstanceController::class, 'bulkDestroyListings']);
            Route::post('{integration_instance}/listings/deletable',
                [IntegrationInstanceController::class, 'isListingDeletable']);

            Route::get('{integration_instance}/sync-inventory/preview', [IntegrationInstanceController::class, 'previewSyncInventory']);

            // Magento
            Route::put('{integration_instance}/magento/download-orders', [OrderController::class, 'download']);
            Route::put('{integration_instance}/magento/download-products',
                [Magento\ProductController::class, 'download']);
            Route::get('{integration_instance}/magento/download-stores', [Magento\StoreController::class, 'download']);
            Route::get('{integration_instance}/magento/stores', [Magento\StoreController::class, 'getStores']);

            Route::get('{integration_instance}/magento/store/mapping',
                [Magento\StoreController::class, 'getStoreMappings']);
            Route::post('{integration_instance}/magento/store/mapping', [Magento\StoreController::class, 'mapStores']);
            Route::delete('{integration_instance}/magento/store/mapping',
                [Magento\StoreController::class, 'destroyPaymentMethodMapping']);
        });
        Route::apiResource('integration-instances', IntegrationInstanceController::class)->except(['index']);
        /**
         * Suppliers Group.
         */
        Route::prefix('suppliers')->name('suppliers.')->group(function () {
            Route::put('{supplier}/archive', [SupplierController::class, 'archive']);
            Route::put('{supplier}/unarchived', [SupplierController::class, 'unarchived']);
            // supplier products
            Route::get('{supplier}/products', [SupplierProductController::class, 'index']);

            // Supplier inventory import
            //    Route::post('{supplier}/inventories/import', [SupplierInventoryController::class, 'importCSV']);

            // Import
            Route::post('/{supplier}/import/preview', [SupplierInventoryController::class, 'previewImport']);
            Route::post('/{supplier}/import', [SupplierInventoryController::class, 'import']);

            // bulk
            Route::put('/archive', [SupplierController::class, 'bulkArchive']);
            Route::put('/unarchive', [SupplierController::class, 'bulkUnArchive']);
            Route::delete('/', [SupplierController::class, 'bulkDestroy']);
            Route::post('/deletable', [SupplierController::class, 'isDeletable']);

            // Supplier Pricing Tiers
            Route::delete('{supplier}/pricing-tiers/{tierId}', [SupplierPricingController::class, 'destroy']);
            Route::get('{supplier}/pricing-tiers', [SupplierPricingController::class, 'fetchForSupplier']);

            // Supplier Warehouses
            Route::get('{supplier}/warehouses', [SupplierWarehouseController::class, 'supplierWarehouses']);
            Route::post('{supplier}/warehouses', [SupplierWarehouseController::class, 'storeWarehouse']);
            Route::post('warehouses/{warehouse}/linked-orders', [SupplierWarehouseController::class, 'linkedOrders']);

            // Import
            Route::post('/import/preview', [SupplierController::class, 'previewImport']);
            Route::post('/import', [SupplierController::class, 'import']);
            Route::post('{supplier}/products-stocks', [SupplierController::class, 'supplierProductsStock']);
        });
        Route::resource('suppliers', SupplierController::class)->except(['edit', 'create']);
        /**
         * Customers Group.
         */
        Route::prefix('customers')->name('customers.')->group(function () {
            Route::get('find-match', [CustomerController::class, 'findMatch']);
            Route::put('{customer}/archive', [CustomerController::class, 'archive']);
            Route::put('{customer}/unarchived', [CustomerController::class, 'unarchived']);
            Route::get('{customer}/addresses', [CustomerController::class, 'addresses']);
            Route::post('{customer}/addresses', [CustomerController::class, 'addAddress']);
            Route::put('{customer}/set-default-shipping-address/{address_id}',
                [CustomerController::class, 'setDefaultShippingAddress']);
            Route::put('{customer}/set-default-billing-address/{address_id}',
                [CustomerController::class, 'setDefaultBillingAddress']);

            // Bulk
            Route::put('/archive', [CustomerController::class, 'bulkArchive']);
            Route::put('/unarchive', [CustomerController::class, 'bulkUnArchive']);
            Route::delete('/', [CustomerController::class, 'bulkDestroy']);
            Route::post('/deletable', [CustomerController::class, 'isDeletable']);

            // Customer Accounting
            Route::get('/{customer}/unpaid-orders', [CustomerAccountingController::class, 'unpaidOrders']);
            Route::get('/{customer}/open-sales-credits', [CustomerAccountingController::class, 'openSalesCredits']);
            Route::post('/{customer}/sales-credits/{salesCredit}/allocate',
                [CustomerAccountingController::class, 'allocateCreditToOrders']);

            // Import
            Route::post('/import/preview', [CustomerController::class, 'previewImport']);
            Route::post('/import', [CustomerController::class, 'import']);

            /**
             * Starshipit.
             */
            Route::prefix('starshipit')->name('starshipit.')->group(function () {
                Route::get('submit-orders', [Starshipit\OrderController::class, 'submitOrders']);
                Route::put('update-order/{sales_order_fulfillment}',
                    [Starshipit\OrderController::class, 'updateOrderFromFulfillment']);
                Route::get('view-order/{sales_order_fulfillment}', [Starshipit\OrderController::class, 'viewOrder']);
            });
        });
        /**
         * CSV Templates.
         */
        Route::prefix('csv-templates')->name('csv-templates.')->group(function () {
            Route::get('{model}/prepare', [CsvTemplateController::class, 'prepare']);
            Route::get('{csvTemplate}/download', [CsvTemplateController::class, 'sample']);
            Route::post('import', [CsvTemplateController::class, 'import']);
            Route::get('{csvTemplate}/export', [CsvTemplateController::class, 'export']);
            Route::put('{csvTemplate}/archive', [CsvTemplateController::class, 'archive']);
            Route::put('{csvTemplate}/unarchived', [CsvTemplateController::class, 'unarchived']);

            // bulk
            Route::put('/archive', [CsvTemplateController::class, 'bulkArchive']);
            Route::put('/unarchive', [CsvTemplateController::class, 'bulkUnArchive']);
        });

        /**
         * Reporting.
         */
        Route::prefix('reporting')->name('reporting.')->group(function () {
            Route::prefix('purchases')->name('purchases.')->group(function () {
                Route::get('summary-by-period', [ReportingController::class, 'purchaseSummaryByPeriod']);
            });
            Route::get('products', [DashboardController::class, 'products']);
            Route::get('orders', [DashboardController::class, 'orders']);
            Route::get('top-selling-products', [DashboardController::class, 'topProducts']);
            Route::get('most-profitable-products', [DashboardController::class, 'mostProfitableProducts']);
            Route::get('ship-by-schedule', [ShipByScheduleController::class, 'index']);
            Route::get('financials-by-brand', [ReportingController::class, 'financialsByBrand']);
            Route::get('financials-by-supplier', [ReportingController::class, 'financialsBySupplier']);
            Route::get('financials-by-sku', [ReportingController::class, 'financialsBySku']);
            Route::get('financials-by-product-type', [ReportingController::class, 'financialsByProductType']);
            Route::get('financials-by-sales-channel', [ReportingController::class, 'financialsBySalesChannel']);
            Route::post('sales-channel-coverage', [ReportingController::class, 'getSalesChannelCoverage'])->name('sales-channel-coverage');

            Route::prefix('accounting')->name('accounting.')->group(function () {
                Route::get('income-statement', [ReportingAccountingController::class, 'incomeStatement']);
            });
        });

        /**
         * ShipStation.
         */
        Route::prefix('shipstation')->name('shipstation.')->group(function () {
            Route::get('submit-orders', [ShipStation\OrderController::class, 'submitOrders']);
            Route::put('update-order/{sales_order_fulfillment}',
                [ShipStation\OrderController::class, 'updateOrderFromFulfillment']);
            Route::post('{integration_instance}/download-shipping-services',
                [ShipStation\OrderController::class, 'downloadShippingServices']);
            Route::post('warehouses/download', [ShipStation\WarehouseController::class, 'download']);
            Route::post('warehouses/map', [ShipStation\WarehouseController::class, 'mapWarehouses']);
            Route::post('warehouses/unmap', [ShipStation\WarehouseController::class, 'unmapWarehouses']);
            Route::get('warehouses/mappings', [ShipStation\WarehouseController::class, 'getWarehouseMappings']);
            Route::get('warehouses', [ShipStation\WarehouseController::class, 'index']);
        });

        /**
         * Shopify.
         */
        Route::prefix('shopify')->name('shopify.')->group(function () {
            Route::post('{integration_instance}/download-shipping-services',
                [Shopify\ShopifyIntegrationController::class, 'downloadShippingServices']);
            Route::get('{integration_instance}/locations', [Shopify\ShopifyIntegrationController::class, 'getLocations']);
            Route::post('{integration_instance}/locations',
                [Shopify\ShopifyIntegrationController::class, 'downloadLocations']);
        });

        /**
         * Starshipit.
         */
        Route::prefix('starshipit')->name('starshipit.')->group(function () {
            Route::get('submit-orders', [Starshipit\OrderController::class, 'submitOrders']);
            Route::put('update-order/{sales_order_fulfillment}',
                [Starshipit\OrderController::class, 'updateOrderFromFulfillment']);
            Route::get('view-order/{sales_order_fulfillment}', [Starshipit\OrderController::class, 'viewOrder']);
        });

        /**
         * Magento.
         */
        Route::prefix('magento')->name('magento.')->group(function () {
            Route::put('{integration_instance}/download-orders', [OrderController::class, 'download']);
            Route::put('{integration_instance}/download-products', [Magento\ProductController::class, 'download']);
            Route::get('{integration_instance}/inventory-sources', [Magento\InventorySourceController::class, 'index']);
            Route::post('{integration_instance}/inventory-sources',
                [Magento\InventorySourceController::class, 'download']);
            Route::get('{integration_instance}/product-attributes',
                [Magento\ProductAttributeController::class, 'index']);
        });
    });

    Route::post('store-file', [UploadController::class, 'upload']);
    Route::get('download-file', [UploadController::class, 'download']);
    Route::get('task-status/{id}', [TaskStatusController::class, 'status']);

    // App settings
    Route::get('app-settings', [AppSettingsController::class, 'index']);

    // Tracked Job Logs
    Route::prefix('tracked-job-logs')->name('tracked-job-logs.')->group(function () {
        Route::get('/retry/{trackedJobLog}', [TrackedJobLogController::class, 'retry']);
    });
    Route::resource('tracked-job-logs', TrackedJobLogController::class)->except(['edit', 'create']);

    Route::resource('custom-fields', CustomFieldController::class)->except(['edit', 'create']);
    Route::resource('custom-field-values', CustomFieldValueController::class)->except(['edit', 'create']);

    Route::resource('sales-channel-product-templates', SalesChannelProductTemplateController::class)->except([
        'edit', 'create',
    ]);

    Route::prefix('financial-alerts')->name('financial-alerts.')->controller(FinancialAlertController::class)->group(function () {
        Route::post('process', 'process')->name('process');
        Route::put('{financialAlert}/archive', 'archive')->name('archive');
        Route::put('{financialAlert}/unarchive', 'unarchive')->name('unarchive');
        Route::resource('/classifications', FinancialAlertClassificationController::class)->except(['edit', 'create']);
        Route::get('/dashboard', [FinancialAlertController::class, 'getDashboardData'])->name('dashboard');
    });
    Route::resource('financial-alerts', FinancialAlertController::class)->except(['edit', 'create', 'show']);
});

// Invited user account setup routes
Route::controller(AccountSetupController::class)->group(function(){
    Route::post('/account-setup','accountSetup')->name('account-setup');
    Route::post('/verify-activation-token','verifyActivationToken')->name('verify.activation.token');
});
