<!doctype html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport"
        content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <title>SKU</title>

  <link href="//maxcdn.bootstrapcdn.com/bootstrap/4.1.1/css/bootstrap.min.css" rel="stylesheet" id="bootstrap-css">
  <script src="//maxcdn.bootstrapcdn.com/bootstrap/4.1.1/js/bootstrap.min.js"></script>
  <script src="//cdnjs.cloudflare.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>


  <style>
    #invoice {
      padding: 30px;
    }

    .invoice {
      position: relative;
      background-color: #FFF;
      min-height: 680px;
      padding: 15px
    }

    .invoice header {
      padding: 10px 0;
      margin-bottom: 20px;
      border-bottom: 1px solid #3989c6
    }

    .invoice .company-details {
      text-align: right
    }

    .invoice .company-details .name {
      margin-top: 0;
      margin-bottom: 0
    }

    .invoice .contacts {
      margin-bottom: 20px
    }

    .invoice .invoice-to {
      text-align: left
    }

    .invoice .invoice-to .to {
      margin-top: 0;
      margin-bottom: 0
    }

    .invoice .invoice-details {
      text-align: right
    }

    .invoice .invoice-details .invoice-id {
      margin-top: 0;
      color: #3989c6
    }

    .invoice main {
      padding-bottom: 50px
    }

    .invoice main .thanks {
      margin-top: -100px;
      font-size: 2em;
      margin-bottom: 50px
    }

    .invoice main .notices {
      padding-left: 6px;
      border-left: 6px solid #3989c6
    }

    .invoice main .notices .notice {
      font-size: 1.2em
    }

    .invoice table {
      width: 100%;
      border-collapse: collapse;
      border-spacing: 0;
      margin-bottom: 20px
    }

    .invoice table td, .invoice table th {
      padding: 15px;
      background: #eee;
      border-bottom: 1px solid #fff
    }

    .invoice table th {
      white-space: nowrap;
      font-weight: 400;
      font-size: 16px
    }

    .invoice table td h3 {
      margin: 0;
      font-weight: 400;
      color: #3989c6;
      font-size: 1.2em
    }

    .invoice table .qty, .invoice table .total, .invoice table .unit {
      text-align: right;
      font-size: 1.2em
    }

    .invoice table .no {
      color: #fff;
      font-size: 1.6em;
      background: #3989c6
    }

    .invoice table .unit {
      background: #ddd
    }

    .invoice table .total {
      background: #3989c6;
      color: #fff
    }

    .invoice table tbody tr:last-child td {
      border: none
    }

    .invoice table tfoot td {
      background: 0 0;
      border-bottom: none;
      white-space: nowrap;
      text-align: right;
      padding: 10px 20px;
      font-size: 1.2em;
      border-top: 1px solid #aaa
    }

    .invoice table tfoot tr:first-child td {
      border-top: none
    }

    .invoice table tfoot tr:last-child td {
      color: #3989c6;
      font-size: 1.4em;
      border-top: 1px solid #3989c6
    }

    .invoice table tfoot tr td:first-child {
      border: none
    }

    .invoice footer {
      width: 100%;
      text-align: center;
      color: #777;
      border-top: 1px solid #aaa;
      padding: 8px 0
    }

    @media print {
      .invoice {
        font-size: 11px !important;
        overflow: hidden !important
      }

      .invoice footer {
        position: absolute;
        bottom: 10px;
        page-break-after: always
      }

      .invoice > div:last-child {
        page-break-before: always
      }
    }
  </style>


</head>
<body>

<div id="invoice">
  <div class="invoice overflow-auto">
    <div style="min-width: 600px">
      <header>
        <div class="row">
          <div class="col">
            <a target="_blank" href="https://dev.sku.io">
              <img width="300" height="150" src="https://dev.sku.io/images/3rd_LOGO_1_white_background.png"/>
            </a>
          </div>
          <div class="col company-details">
            <h2 class="name">
              <a target="_blank" href="https://lobianijs.com">
                SKU
              </a>
            </h2>
            <div>455 Foggy Heights, AZ 85004, US</div>
            <div>(123) 456-789</div>
            <div>company@example.com</div>
          </div>
        </div>
      </header>
      <main>
        <div class="row contacts">
          <div class="col invoice-to">
            <div class="text-gray-light">INVOICE TO:</div>
            <h2 class="to">Supplier</h2>
            <div class="address">796 Silver Harbour, TX 79273, US</div>
            <div class="email"><a href="mailto:john@example.com">john@example.com</a></div>
          </div>
          <div class="col invoice-details">
            <h1 class="invoice-id">INVOICE 3-2-1</h1>
            <div class="date">Date of Invoice: 01/10/2018</div>
            <div class="date">Due Date: 30/10/2018</div>
          </div>
        </div>
        <table border="0" cellspacing="0" cellpadding="0">
          <thead>
          <tr>
            <th>#</th>
            <th class="text-left">Description</th>
            <th class="text-right">Unit Cost</th>
            <th class="text-right">Quantity</th>
            <th class="text-right">TOTAL</th>
          </tr>
          </thead>
          <tbody>

          @foreach($purchaseOrder->purchaseOrderLines as $index => $line)
            <tr>
              <td class="no">{{($index+1)}}</td>
              <td class="text-left">
                <h3>
                  <a target="#">
                    {{$line->product ? ($line->supplier_product->supplier_sku ?? $line->product->sku) : ''}}
                  </a>
                </h3>
                {{ $line->description }}
              </td>
              <td class="unit">${{$line->amount}}</td>
              <td class="qty">{{$line->quantity}}</td>
              <td class="total">${{$line->subtotal}}</td>
            </tr>
          @endforeach

          </tbody>
          <tfoot>
          <tr>
            <td colspan="2"></td>
            <td colspan="2">PRODUCT TOTAL</td>
            <td>${{$purchaseOrder->product_total}}</td>
          </tr>
          <tr>
            <td colspan="2"></td>
            <td colspan="2">ADDITIONAL COST</td>
            <td>${{$purchaseOrder->additional_cost}}</td>
          </tr>
          <tr>
            <td colspan="2"></td>
            <td colspan="2">TAX COST</td>
            <td>${{$purchaseOrder->tax_cost}}</td>
          </tr>
          <tr>
            <td colspan="2"></td>
            <td colspan="2">TOTAL</td>
            <td>${{$purchaseOrder->total}}</td>
          </tr>
          </tfoot>
        </table>
        <div class="thanks">Thank you!</div>
        <div class="notices">
          <div>NOTICE:</div>
          <div class="notice">A finance charge of 1.5% will be made on unpaid balances after 30 days.</div>
        </div>
      </main>
      <footer>
        Invoice was created on a computer and is valid without the signature and seal.
      </footer>
    </div>
    <!--DO NOT DELETE THIS div. IT is responsible for showing footer always at the bottom-->
    <div></div>
  </div>
</div>


</body>
</html>
