@extends('layouts.app')

@section('content')
<div class="container reset-email">
    <div class="hover-card">

        @include('includes.logo')

        <form method="POST" action="{{ route('password.update') }}">

            <input id="token" type="hidden" name="token" value="{{ $token }}">

            <div class="form-group">
                <input
                    id="emailReset"
                    type="email"
                    class="form-control @error('email') is-invalid @enderror"
                    name="email"value="{{ old('email') ?? $email }}"
                    required
                    autofocus
                >
                <div class="floater"></div>
                <span id="email-error-message" class="invalid-feedback absolute alert-hidden" role="alert"></span>
            </div>


            <div class="form-group">
                <input
                    id="passwordReset"
                    type="password"
                    class="form-control @error('password') is-invalid @enderror"
                    name="password"
                    required
                >
                <div class="floater"></div>
                <span id="password-error-message" class="invalid-feedback absolute alert-hidden" role="alert"></span>
            </div>

            <div class="form-group">
                <input
                    id="passwordConfirm"
                    type="password"
                    class="form-control @error('password_confirmation') is-invalid @enderror"
                    name="password_confirmation"
                    required
                >
                <div class="floater"></div>
                <span id="confirmation-error-message" class="invalid-feedback absolute alert-hidden" role="alert"></span>
            </div>

            <div class="form-group">
                <button id="resetPasswordBtn" type="submit" class="card-actions--button">
                    {{ __('Reset Password') }}
                </button>
            </div>

        </form>

    </div>

</div>

<script>
    const emailEl           = $('emailReset')
    const passwordEl        = $('passwordReset')
    const passwordConfirmEl = $('passwordConfirm')

    const errorElementsData = {
      email: { el: emailEl, messageId: 'email-error-message' },
      password: { el: passwordEl, messageId: 'password-error-message' },
      confirmation: { el: passwordConfirmEl, messageId: 'confirmation-error-message' },
    }
    let errorMessages

    localStorage.removeItem('SKUtoken')
    localStorage.removeItem('isExpireToken')

    next = '/login'

    const parsePasswordErrorMessages = (messages) => {
      return messages.reduce((acc, item) => {
        if (typeof item === 'object' && item !== null && item.hasOwnProperty('message')) {
          const message = item.message
          if (item.hasOwnProperty('code') && item.code === 'PasswordConfirmed') {
            acc.confirmation = `<strong>${message}</strong><br>`
          } else {
            acc.password = `<strong>${message}</strong><br>`
          }
        }
        return acc
      }, {})
    }

    const setErrorMessages = () => {
      for (const key in errorMessages) {
        const elData = errorElementsData[key]
        const errorMessageEl = $(elData.messageId)
        errorMessageEl.innerHTML = errorMessages[key]
        errorMessageEl.classList.remove('alert-hidden')
        elData.el.classList.remove('is-invalid')
        if (errorMessages[key]) elData.el.classList.add('is-invalid')
      }
    }

    let error = (http) => {
      let response = JSON.parse(http.response)

      if(!response) return
      if ( response.errors.hasOwnProperty('email') ) {
        errorMessages = {
          ...errorMessages,
          email: parseErrorMessages(response.errors.email)
        }
      }
      if ( response.errors.hasOwnProperty('password') ) {
        errorMessages = {
          ...errorMessages,
          ...parsePasswordErrorMessages(response.errors.password)
        }
      }
      setErrorMessages()
    }

    [emailEl, passwordEl, passwordConfirmEl].forEach(el => {
        el.addEventListener('input', (e) => {
          e.target.classList.remove('is-invalid')
          e.target.parentElement.querySelector('.invalid-feedback').classList.add('alert-hidden')
        })
    })

    $('resetPasswordBtn').addEventListener('click', (e) => {
      errorMessages = {
        email: null,
        password: null,
        confirmation: null,
      }
      setErrorMessages()

      sendRequest('/password/reset', {
        email: emailEl.value,
        token: $('token').value,
        password: passwordEl.value,
        password_confirmation: passwordConfirmEl.value
      })
      e.preventDefault()
    })
</script>

@endsection
