@extends('layouts.app')

@section('content')
<div class="container reset-email">
    <div class="hover-card">

        @include('includes.logo')

        <div class="hover-card--title">
            <h2>Reset Password</h2>
        </div>

        <form method="POST" action="{{ route('password.email') }}">
            <div class="form-group">
                <input
                    placeholder=" "
                    id="emailReset"
                    name="email"
                    required
                    class="@error('email') is-invalid @enderror form-control"
                    value="{{old('email')}}"
                >
                <div class="floater"></div>

                <span id="email-error-message" class="invalid-feedback absolute alert-hidden" role="alert"></span>
            </div>

            <button
                id="resetPasswordButton"
                type="submit"
                class="card-actions--button"
            >
                {{ __('Send Reset Request') }}
            </button>
            <a href="{{ route('login') }}" class="card-actions--forgot">
                {{ __('Go back') }}
            </a>
        </form>
    </div>
</div>
<script>
  const emailEl = $('emailReset')
  const errorMessageEl = $('email-error-message')
  let errorMessages = null
  emailEl.classList.remove('is-invalid')

  let error = (http) => {
    let response = JSON.parse(http.response)
    if(response) {
      errorMessages = parseErrorMessages(response.errors.email)

      if (errorMessages) {
        emailEl.classList.add('is-invalid')
        errorMessageEl.innerHTML = errorMessages
        errorMessageEl.classList.remove('alert-hidden')
      }
    }
  }

  $('resetPasswordButton').addEventListener('click', (e) => {
    let email = emailEl.value
    emailEl.classList.remove('is-invalid')
    sendRequest('/password/email', {email: email})
    e.preventDefault()
  })

  emailEl.addEventListener('input', () => {
    if (errorMessages) {
      emailEl.classList.remove('is-invalid')
      errorMessageEl.classList.add('alert-hidden')
      errorMessages = null
    }
  })
</script>
@endsection
