@extends('layouts.app')

@section('content')
<div class="container">
    <div class="hover-card">

        @include('includes.logo')

        <form method="POST" action="{{ route('login') }}" >

            @csrf

            <div class="pages">
                <div class="page active" id="email">
                    <div class="form-group">
                        <input id="r" type="hidden" name="r" value="{{ Request::get('r') }}">
                        <input autofocus placeholder=" " id="emailLogin" class="form-control" name="email" value="">
                        <div class="floater"></div>
                    </div>

                    <div class="form-group">
                        <input placeholder=" " id="passwordLogin" type="password" class="form-control" name="password" value="">
                        <div class="floater"></div>
                    </div>

                    <div class="card-actions--remember">
                        <label>
                        {{ __('Remember Me') }}
                        <input type="checkbox" checked="checked" name="remember" id="remember">
                        <span class="checkmark"></span>
                        </label>
                    </div>

                    <button id="loginButton" type="button" class="card-actions--button ">
                        {{ __('Login') }}
                    </button>

                    @if (Route::has('password.request'))
                    <div class="tall">
                        <a
                        href="{{ route('password.request') }}"
                        class="card-actions --forgot"
                        >
                        {{ __('Forgot Your Password?') }}
                        </a>
                    </div>
                    @endif

                </div>

                <div class="page" id="email_2fa">

                    <a href="#"
                        class="card-actions change-account"
                    >
                        &lt; &nbsp; {{ __('Change account') }}
                    </a>

                    <div class="card-actions tall">
                        {{ __('Check your mailbox for the code we just sent you.') }}
                    </div>

                    <div class="tall">
                        <input placeholder=" " id="email2faLogin" type="text" class="form-control" name="email2fa" value="">
                        <div class="floater"></div>
                    </div>

                    <button id="2faButton" type="button" class="card-actions--button ">
                        {{ __('Proceed') }}
                    </button>

                </div>

            </div>

       </form>
   </div>
</div>
<script>
  const redirectTo = localStorage.getItem('redirectTo')
  next = redirectTo ?? '/dashboard';

  receive = (http) => {
    let parsed_token = JSON.parse(http.response)
    if(parsed_token) {
      localStorage.setItem('SKUtoken', http.response);
      redirect(next)
    }
  }

  let error = ({response}) => {
    let data = JSON.parse(response)

        if (data.error=="2fa_email") {
            gotopage("email_2fa")
        } else {
            showAlertMessage(data?.error || 'Login error: Wrong email or password.', 'error')
        }

  }

  $('loginButton').addEventListener('click', (e) => {
    e.preventDefault()
    const email = $('emailLogin').value
    const password = $('passwordLogin').value
    const remember = $('remember').checked
    const csrf = document.head.querySelector("meta[name=csrf-token][content]").content
    const new2fa = true;
    sendRequest('/api/auth/login', { email, password, remember, new2fa, csrf })
  }, false)

  document.querySelectorAll(".change-account").forEach( (e) => {
    e.addEventListener("click", x => gotopage("email"))
  }, false)

  $('2faButton').addEventListener('click', (e) => {
    e.preventDefault()
    const email = $('emailLogin').value
    const password = $('passwordLogin').value
    const email2fa = $('email2faLogin').value
    const remember = $('remember').checked
    const csrf = document.head.querySelector("meta[name=csrf-token][content]").content
    sendRequest('/api/auth/login', { email, password, remember, email2fa, csrf })
  }, false)

  const isExpiredTokenKey = 'isExpireToken'
  const isExpiredToken = localStorage.getItem(isExpiredTokenKey)

  if (+isExpiredToken) {
    showAlertMessage('Login session expired. Please login again', 'success', 5000)
    localStorage.removeItem(isExpiredTokenKey)
  }


  // Pagination
  function gotopage(page) {
      let last = document.querySelector(".pages .page.active");
      let new_active = document.querySelector(".pages .page#"+page);
      document.querySelectorAll(".pages .page").forEach( (x) => {
        x.classList.remove("last");
        x.classList.remove("active");
      });
      last.classList.add("last");
      new_active.classList.add("active");
      setTimeout( () => { last.classList.remove("last"); }, 200);
  }

</script>
<style>
.center {
    text-align: center;
    vertical-align: middle;
    display: table-cell;
}
.pages {
    width: 300px;
    height: 350px;
    margin: auto;
    overflow: hidden;
    position: relative;
}
.page {
    display: inline-block;
    visibility: hidden;
    opacity: 0;
    width: 100%;
    height: 100%;
    position: absolute;
    left: 100%;
    transition:left 0.2s linear;
}
.page.last {
    visibility: visible;
    opacity: 1;
    left: -100%;
}
.page.active {
    visibility: visible;
    opacity: 1;
    left: 0;
}

.page .right {
    float: right;
}

.page .left {
    float: left;
}

.page .tall {
    height: 40px;
    margin-top: 40px;
    margin-bottom: 40px;
}

.page button.half {
    width: 125px;
}

.pages .page .form-control {
    height: 30px;
}

.pages .page {
    background-color: white;
}

.pages .page a {
    text-decoration: none;
}
</style>

@endsection
