import VueRouter from 'vue-router';

let routes = [
  {
    path: '/',
    component: require('./views/Dashboard').default
  },
  {
    path: '/settings',
    component: require('./views/Settings').default,
    children: [
      {
        path: 'sales_channels',
        redirect: 'sales_channels/1'
      },
      {
        path: 'sales_channels/:page',
        component: require ('./views/settings/SalesChannels').default,
        props: true,
        children: [
          {
            path: 'create',
            component: require('./views/settings/sales_channels/SalesChannelCreate').default
          }
        ]
      }
    ]
  },
  {
    path: '/admin',
    component: require('./views/AdminTools').default,
    children: [
      {
        path: 'amazon/feed_submissions',
        component: require ('./views/admin/amazon/FeedSubmissions').default
      },
      {
        path: 'amazon/orders',
        component: require ('./views/admin/amazon/Orders').default
      }
    ]
  },
  {
    path: '/ebay-auth-accepted',
    component: require('./views/settings/sales_channels/EbayAuthAccepted').default
  },
  {
    path: '/shopify-auth-accepted',
    component: require('./views/settings/sales_channels/ShopifyAuthAccepted').default
  },
  {
    path: '/google-express-auth-accepted',
    component: require('./views/settings/sales_channels/GoogleExpressAuthAccepted').default
  }
  /*{
    path: '/settings/sales_channels',
    component: require('./views/settings/SalesChannels').default
  }*/
];

export default new VueRouter(
  {
    routes,
    linkActiveClass: 'active'
  });
