import { authXero } from '@/services/XeroServices'
import showErrors from '@/support/showErrors'

export default {
  data () {
    return {
      finalizing: false,
    }
  },
  methods: {
    async authXeroInstance () {
      try {
        this.finalizing = true
        const data = await authXero()
        if (data) window.location.href = data
      } catch (e) {
        showErrors.call(this, e)
      } finally {
        this.finalizing = false
      }
    },
  }
}
