import { isEqual } from 'lodash'

export default (localItems, initialItems, fields = ['name', 'rate']) => {
  if (!localItems || !initialItems || !initialItems.length) return false
  if (localItems.length !== initialItems.length) return true
  // no items - nothing to track
  // changes inside of items
  let initialObj = {}
  let localObj = {}

  for (let i = 0; i < initialItems.length; i++) {
    const initialItem = initialItems[i]
    const localItem = localItems[i]

    fields.forEach(field => {
      initialObj[field] = initialItem[field] || ''
      localObj[field] = localItem[field] || ''
    })

    if (!isEqual(initialObj, localObj)) return true
  }
  return false
}
