export const getItemsRequest = async (query, commit, itemRequest) => {
  try {
    commit('SET_LOADING', true)
    const {data,table_specifications} = await itemRequest(query)
    commit('SET_ITEMS_LIST', data)
    if (table_specifications) commit('SET_TABLE_SPECIFICATIONS', table_specifications)
  } catch (e) {
    return Promise.reject(e)
  } finally {
    commit('SET_LOADING', false)
  }
}

export const getTableMetaRequest = async (query, commit, itemRequest) => {
  try {
    const {meta} = await itemRequest(query)
    if (meta?.last_page) commit('SET_MAX_PAGES', meta.last_page)
    if (meta) commit('SET_META', meta)
  } catch (e) {
    return Promise.reject(e)
  }
}

export const getTableSpecificationsRequest = async (query, commit, itemRequest) => {
  try {
    const {table_specifications} = await itemRequest(query)
    if (table_specifications) commit('SET_TABLE_SPECIFICATIONS', table_specifications)
    return Promise.resolve()
  } catch (e) {
    return Promise.reject(e)
  }
}
