import router from '@/router.js'
import { isNavigationFailure, NavigationFailureType } from 'vue-router/src/util/errors'

const pushToRoute = (params) => {
  router.push(params).catch(error => {
    if (!isNavigationFailure(error, NavigationFailureType.duplicated)) throw error
  })
}

export function updateGivenQueryName (layer, key, value) {
  let currentQuery = JSON.parse(JSON.stringify(router.app._route.query))
  if (!currentQuery || !currentQuery.hasOwnProperty(layer)) return
  const params = currentQuery[layer].split(';')
    .reduce((acc,param) => {
      if (param.search(`${key}:`) !== -1) param = `${key}:${value}`
      acc = [...acc, param]
      return acc
    },[])
    .join(';')
    
  pushToRoute({query: {...currentQuery,[layer]:params}})
}
