export default (value, propertyName, vm) => {
  if (value === '') return vm.$set(vm, propertyName, value)

  if (value.match(/^\d+$/) || Number(value) > 0) return vm.$set(vm, propertyName, Math.abs(value))

  vm.$set(vm, propertyName, null)
  
  vm.$nextTick(() => {
    vm.$set(vm, propertyName, Math.abs(vm[propertyName]))
  })
}
