(function () { // make vuetify and SKUModal movable
  function isModal (e) {
    const closestModal = e.target.closest('.v-dialog--active')
    let closestHeader
    if (closestModal) closestHeader = e.target.closest('.modal-title')
    if (e.button === 0 && closestModal != null && closestHeader &&  typeof e.target.className === 'string' &&
      !e.target.className.includes('sku-modal--title') && !e.target.className.includes('sku-modal--close') &&
      !e.target.className.includes('sku-modal--close-button') && !e.target.className.includes('title-span') &&
      !e.target.className.includes('close')
    ) {
      return closestModal
    }
    return false
  }

  const d = {}
  document.addEventListener('mousedown', e => {
    const closestModal = isModal(e)
    if (closestModal) { // element which can be used to move element
      d.el = closestModal // element which should be moved
      d.mouseStartX = e.clientX
      d.mouseStartY = e.clientY
      d.elStartX = d.el.getBoundingClientRect().left
      d.elStartY = d.el.getBoundingClientRect().top
      d.el.style.position = 'fixed'
      d.el.style.margin = 0
      d.oldTransition = d.el.style.transition
      d.el.style.transition = 'none'
    }
  })
  document.addEventListener('mousemove', e => {
    if (d.el === undefined) return
    d.el.style.left = d.elStartX + e.clientX - d.mouseStartX + 'px'
    d.el.style.top = d.elStartY + e.clientY - d.mouseStartY + 'px'

    // don't allow to cross the boundaries (out of bounds)
    // d.el.style.left = Math.min(
    //   Math.max(d.elStartX + e.clientX - d.mouseStartX, 0),
    //   window.innerWidth - d.el.getBoundingClientRect().width
    // ) + 'px'
    // d.el.style.top = Math.min(
    //   Math.max(d.elStartY + e.clientY - d.mouseStartY, 0),
    //   window.innerHeight - d.el.getBoundingClientRect().height
    // ) + 'px'
  })
  document.addEventListener('mouseup', () => {
    if (d.el === undefined) return
    d.el.style.transition = d.oldTransition
    d.el = undefined
  })
  // setInterval(() => { // prevent out of bounds on screen width change
  //   const dialog = document.querySelector('.v-dialog.v-dialog--active')
  //   if (dialog === null) return
  //   dialog.style.left = Math.min(parseInt(dialog.style.left), window.innerWidth - dialog.getBoundingClientRect().width) + 'px'
  //   dialog.style.top = Math.min(parseInt(dialog.style.top), window.innerHeight - dialog.getBoundingClientRect().height) + 'px'
  // }, 100)
})()
