export const getInstanceUrl = (instanceId, integrationName, path = '') => {
  const baseUrl = `/${integrationName}/${instanceId}`
  return path ? `${baseUrl}/${path}` : baseUrl
}

export const getUrl = (instanceId, integrationName, baseUrl, path = '') => {
  const pathName = path ? `${baseUrl}/${path}` : baseUrl
  return getInstanceUrl(instanceId, integrationName, pathName)
}

export const isFailedRequest = ({status, errors = null}) => (status === 'failure' && errors !== null)
