import {
  intersection,
} from 'lodash'

export const getWarehousesPriorityList = (settings) => {
  let priorityList = []
  const priorityObject = settings.find(i => i.key === 'warehouse_priority')
  if (priorityObject) priorityList = Array.from(new Set(JSON.parse(priorityObject.value)))

  return priorityList
}

export const getDefaultWarehouse = (priorityList, warehousesList) => {
  const intesectionWarehouses = intersection(priorityList,warehousesList)
  if(intesectionWarehouses.length) return intesectionWarehouses[0]

  return null
}
