import exactMath from 'exact-math'

export default (digit, count = -4) => {
  digit = exactMath.round(Number(digit || 0), count)
  const stringifiedDigit = String(digit)
  const number = digit
  let result

  // if has values after coma
  if (stringifiedDigit.indexOf('.') !== -1) {
    // get digits after coma
    const digitsAfterComa = stringifiedDigit.split('.')[1]
    // if length === 4 check the last and if it !== 0 show 4 digits after coma, etc...
    if (digitsAfterComa[3] && digitsAfterComa[3] !== '0') {
      result = number.toFixed(4)
    } else if (digitsAfterComa[2] && digitsAfterComa[2] !== '0') {
      result = number.toFixed(3)
    } else {
      result = number.toFixed(2)
    }
  } else {
    result = number.toFixed(2)
  }

  return result
}
