import exactMath from 'exact-math'

export const prepareFinancialLines = (lines = []) => {
  return lines.map(l => {
    if (!l.hasOwnProperty('financial_line_type_id')) {
      l.financial_line_type_id = l.financial_line_type?.id || null
    }
    return l
  })
}

export const filterLinesByClassification = (name, lines = []) => {
  return lines.filter(({financial_line_type}) => (
    financial_line_type?.classification === name || !financial_line_type?.classification)
  )
}

export const calculateLinesTotal = (lines = []) => {
  return lines.reduce((acc,{amount = 0,quantity = 0}) => {
    const total = exactMath.mul(parseFloat(quantity || 0),parseFloat(amount || 0))
    acc = exactMath.add(acc,total)
    return acc
  }, 0) || 0
}