export default (value, item, list, propName, vm) => {
  const index = list.findIndex(entity => entity.id === item.id)
  if (value === '') {
    item[propName] = value
    return vm.$set(list, index, item)
  }

  if (value.match(/^\d+$/) || Number(value) > 0) {
    item[propName] = Math.abs(value)
    return vm.$set(list, index, item)
  }

  // not a number
  const prevValue = item[propName]
  // artificialy reset value to update it despite that newValue didn't change
  item[propName] = null
  vm.$set(list, index, item)
  vm.$nextTick(() => {
    item[propName] = Math.abs(prevValue)
    vm.$set(vm.items, index, item)
  })
}
