import axiosConfig from '@/config/axiosConfig'
import { getRandomId } from '@/support/helpers'

export const getAxiosRequest = async (url, params = null) => {
  try {
    const { data } = await axiosConfig.get(url, params)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const postAxiosRequest = async (url, sendData = null, params = {}) => {
  try {
    const { data } = await axiosConfig.post(url, sendData, params)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const putAxiosRequest = async (url, sendData = null) => {
  try {
    const { data } = await axiosConfig.put(url, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const deleteAxiosRequest = async (url, sendData = null) => {
  try {
    const { data } = await axiosConfig.delete(url, sendData)
    return data
  } catch (e) {
    return Promise.reject(e)
  }
}

export const getTableFilters = (filters = [], updateIds = false) => {
  const filterSet = updateIds ? filters.map(f => ({ ...f, id: getRandomId() })): filters
  return { filters: JSON.stringify({ conjunction: 'and', filterSet, }), }
}

export const getFilter = (column, value, operator = '=', dateOption = '') => {
  return { id: getRandomId(), column, operator, dateOption, value}
}
