import Vue from 'vue'
import Vuex from 'vuex'
import VuexPersist from 'vuex-persist'
import Cookies from 'js-cookie'

Vue.use(Vuex)

// Import all of the resource store files.
function loadStoreModules () {
  const context = require.context('@/store/modules', true, /.js$/i)
  return context
    .keys()
    .map(context)// import module
}

let resourceModules = loadStoreModules().reduce((acc,module) => {
  const [name] = Object.keys(module)
  if (name !== 'default') acc = {...acc, [name]: module[name] }
  return acc
},{})

// Store Persistence in Cookies
const vuexCookie = new VuexPersist({
  restoreState: (key, storage) => Cookies.getJSON('app'),
  saveState: (key, state, storage) =>
    Cookies.set('sku', state, {
      expires: 3,
    }),
  modules: ['UsersModule'],
})

// Vuex Persist Store
const vuexPersist = new VuexPersist({
  key: 'vuex',
  storage: localStorage,
  modules: ['WizardModule'],
})

export default new Vuex.Store({
  namespaced: true,
  plugins: [vuexCookie.plugin, vuexPersist.plugin],
  modules: resourceModules,
  state: {
    leftDrawer: false,
    fixedDrawer: false,
    searchModal: false,
  },
  getters: {
    searchModal: (state) => state.searchModal,
    leftDrawer: (state) => state.leftDrawer,
    fixedDrawer: (state) => state.fixedDrawer,
    baseUrl: (state) => state.baseUrl,
  },
  mutations: {
    // Set dashboard search modal mutation
    SET_SEARCH_MODAL(state, visible) {
      state.searchModal = visible
    },
    // Set navigation drawer mutation
    SET_DRAWER(state, visible) {
      state.leftDrawer = visible
    },
    // Set mini navigation drawer mutation
    SET_FIXED_DRAWER(state) {
      state.fixedDrawer = !state.fixedDrawer
    },
  },
  actions: {
    // Set dashboard search modal action
    setSearchModal({ commit }, visible) {
      commit('SET_SEARCH_MODAL', visible)
    },
    // Set navigation drawer action
    setDrawer({ commit }, visible) {
      commit('SET_DRAWER', visible)
    },
    // Set mini navigation drawer action
    setFixedDrawer({ commit }, visible) {
      commit('SET_FIXED_DRAWER', visible)
    },
  },
})
